/*
 * Decompiled with CFR 0.152.
 */
package io.nem.sdk.infrastructure.okhttp;

import io.nem.sdk.api.ChainRepository;
import io.nem.sdk.infrastructure.okhttp.AbstractRepositoryOkHttpImpl;
import io.nem.sdk.model.blockchain.BlockchainScore;
import io.nem.sdk.openapi.okhttp_gson.api.ChainRoutesApi;
import io.nem.sdk.openapi.okhttp_gson.invoker.ApiClient;
import io.nem.sdk.openapi.okhttp_gson.model.ChainScoreDTO;
import io.nem.sdk.openapi.okhttp_gson.model.HeightInfoDTO;
import io.reactivex.Observable;
import java.math.BigInteger;
import java.util.concurrent.Callable;

public class ChainRepositoryOkHttpImpl
extends AbstractRepositoryOkHttpImpl
implements ChainRepository {
    private final ChainRoutesApi client;

    public ChainRepositoryOkHttpImpl(ApiClient apiClient) {
        super(apiClient);
        this.client = new ChainRoutesApi(apiClient);
    }

    public ChainRoutesApi getClient() {
        return this.client;
    }

    public Observable<BigInteger> getBlockchainHeight() {
        Callable<HeightInfoDTO> callback = () -> ((ChainRoutesApi)this.getClient()).getChainHeight();
        return this.exceptionHandling(this.call(callback).map(blockchainHeight -> blockchainHeight.getHeight()));
    }

    public Observable<BlockchainScore> getChainScore() {
        Callable<ChainScoreDTO> callback = () -> ((ChainRoutesApi)this.getClient()).getChainScore();
        return this.exceptionHandling(this.call(callback).map(blockchainScoreDTO -> new BlockchainScore(blockchainScoreDTO.getScoreLow(), blockchainScoreDTO.getScoreHigh())));
    }
}

