/*
 * Decompiled with CFR 0.152.
 */
package io.nem.sdk.infrastructure.okhttp.mappers;

import io.nem.sdk.infrastructure.okhttp.mappers.AbstractTransactionMapper;
import io.nem.sdk.model.account.PublicAccount;
import io.nem.sdk.model.blockchain.NetworkType;
import io.nem.sdk.model.transaction.JsonHelper;
import io.nem.sdk.model.transaction.MultisigAccountModificationTransaction;
import io.nem.sdk.model.transaction.MultisigAccountModificationTransactionFactory;
import io.nem.sdk.model.transaction.TransactionType;
import io.nem.sdk.openapi.okhttp_gson.model.MultisigAccountModificationTransactionDTO;
import java.util.List;
import java.util.stream.Collectors;

class MultisigAccountModificationTransactionMapper
extends AbstractTransactionMapper<MultisigAccountModificationTransactionDTO, MultisigAccountModificationTransaction> {
    public MultisigAccountModificationTransactionMapper(JsonHelper jsonHelper) {
        super(jsonHelper, TransactionType.MODIFY_MULTISIG_ACCOUNT, MultisigAccountModificationTransactionDTO.class);
    }

    protected MultisigAccountModificationTransactionFactory createFactory(NetworkType networkType, MultisigAccountModificationTransactionDTO transaction) {
        List additions = transaction.getPublicKeyAdditions().stream().map((? super T publicKey) -> PublicAccount.createFromPublicKey((String)publicKey, (NetworkType)networkType)).collect(Collectors.toList());
        List deletions = transaction.getPublicKeyDeletions().stream().map((? super T publicKey) -> PublicAccount.createFromPublicKey((String)publicKey, (NetworkType)networkType)).collect(Collectors.toList());
        return MultisigAccountModificationTransactionFactory.create((NetworkType)networkType, (byte)transaction.getMinApprovalDelta().byteValue(), (byte)transaction.getMinRemovalDelta().byteValue(), additions, deletions);
    }

    @Override
    protected void copyToDto(MultisigAccountModificationTransaction transaction, MultisigAccountModificationTransactionDTO dto) {
        dto.setMinApprovalDelta(Integer.valueOf(transaction.getMinApprovalDelta()));
        dto.setMinRemovalDelta(Integer.valueOf(transaction.getMinRemovalDelta()));
        dto.setPublicKeyAdditions(transaction.getPublicKeyAdditions().stream().map((? super T p) -> p.getPublicKey().toHex()).collect(Collectors.toList()));
        dto.setPublicKeyDeletions(transaction.getPublicKeyDeletions().stream().map((? super T p) -> p.getPublicKey().toHex()).collect(Collectors.toList()));
    }
}

