/*
 * Decompiled with CFR 0.152.
 */
package io.nem.sdk.infrastructure.okhttp.mappers;

import io.nem.core.utils.ConvertUtils;
import io.nem.core.utils.MapperUtils;
import io.nem.sdk.infrastructure.okhttp.mappers.AbstractTransactionMapper;
import io.nem.sdk.model.account.PublicAccount;
import io.nem.sdk.model.blockchain.NetworkType;
import io.nem.sdk.model.mosaic.UnresolvedMosaicId;
import io.nem.sdk.model.transaction.JsonHelper;
import io.nem.sdk.model.transaction.MosaicMetadataTransaction;
import io.nem.sdk.model.transaction.MosaicMetadataTransactionFactory;
import io.nem.sdk.model.transaction.TransactionType;
import io.nem.sdk.openapi.okhttp_gson.model.MosaicMetadataTransactionDTO;
import java.math.BigInteger;

class MosaicMetadataTransactionMapper
extends AbstractTransactionMapper<MosaicMetadataTransactionDTO, MosaicMetadataTransaction> {
    public MosaicMetadataTransactionMapper(JsonHelper jsonHelper) {
        super(jsonHelper, TransactionType.MOSAIC_METADATA_TRANSACTION, MosaicMetadataTransactionDTO.class);
    }

    protected MosaicMetadataTransactionFactory createFactory(NetworkType networkType, MosaicMetadataTransactionDTO transaction) {
        PublicAccount targetAccount = PublicAccount.createFromPublicKey((String)transaction.getTargetPublicKey(), (NetworkType)networkType);
        Integer valueSizeDelta = transaction.getValueSizeDelta();
        BigInteger scopedMetaDataKey = new BigInteger(transaction.getScopedMetadataKey(), 16);
        String value = ConvertUtils.fromHexToString((String)transaction.getValue());
        UnresolvedMosaicId targetMosaic = MapperUtils.toUnresolvedMosaicId((String)transaction.getTargetMosaicId());
        MosaicMetadataTransactionFactory factory = MosaicMetadataTransactionFactory.create((NetworkType)networkType, (PublicAccount)targetAccount, (UnresolvedMosaicId)targetMosaic, (BigInteger)scopedMetaDataKey, (String)value);
        factory.valueSizeDelta(valueSizeDelta.intValue());
        Integer valueSize = transaction.getValueSize();
        if (valueSize != null) {
            factory.valueSize(valueSize.intValue());
        }
        return factory;
    }

    @Override
    protected void copyToDto(MosaicMetadataTransaction transaction, MosaicMetadataTransactionDTO dto) {
        dto.setTargetPublicKey(transaction.getTargetAccount().getPublicKey().toHex());
        dto.setTargetMosaicId(MapperUtils.getIdAsHex((UnresolvedMosaicId)transaction.getTargetMosaicId()));
        dto.setScopedMetadataKey(transaction.getScopedMetadataKey().toString());
        dto.setValue(ConvertUtils.fromStringToHex((String)transaction.getValue()));
        dto.setValueSizeDelta(Integer.valueOf(transaction.getValueSizeDelta()));
        dto.setValueSize(Integer.valueOf(transaction.getValueSize()));
    }
}

