/*
 * Decompiled with CFR 0.152.
 */
package io.nem.sdk.infrastructure.okhttp.mappers;

import io.nem.sdk.infrastructure.okhttp.mappers.AccountAddressRestrictionTransactionMapper;
import io.nem.sdk.infrastructure.okhttp.mappers.AccountLinkTransactionMapper;
import io.nem.sdk.infrastructure.okhttp.mappers.AccountMetadataTransactionMapper;
import io.nem.sdk.infrastructure.okhttp.mappers.AccountMosaicRestrictionTransactionMapper;
import io.nem.sdk.infrastructure.okhttp.mappers.AccountOperationRestrictionTransactionMapper;
import io.nem.sdk.infrastructure.okhttp.mappers.AddressAliasTransactionMapper;
import io.nem.sdk.infrastructure.okhttp.mappers.AggregateTransactionMapper;
import io.nem.sdk.infrastructure.okhttp.mappers.HashLockTransactionMapper;
import io.nem.sdk.infrastructure.okhttp.mappers.MosaicAddressRestrictionTransactionMapper;
import io.nem.sdk.infrastructure.okhttp.mappers.MosaicAliasTransactionMapper;
import io.nem.sdk.infrastructure.okhttp.mappers.MosaicDefinitionTransactionMapper;
import io.nem.sdk.infrastructure.okhttp.mappers.MosaicGlobalRestrictionTransactionMapper;
import io.nem.sdk.infrastructure.okhttp.mappers.MosaicMetadataTransactionMapper;
import io.nem.sdk.infrastructure.okhttp.mappers.MosaicSupplyChangeTransactionMapper;
import io.nem.sdk.infrastructure.okhttp.mappers.MultisigAccountModificationTransactionMapper;
import io.nem.sdk.infrastructure.okhttp.mappers.NamespaceMetadataTransactionMapper;
import io.nem.sdk.infrastructure.okhttp.mappers.NamespaceRegistrationTransactionMapper;
import io.nem.sdk.infrastructure.okhttp.mappers.SecretLockTransactionMapper;
import io.nem.sdk.infrastructure.okhttp.mappers.SecretProofTransactionMapper;
import io.nem.sdk.infrastructure.okhttp.mappers.TransactionMapper;
import io.nem.sdk.infrastructure.okhttp.mappers.TransferTransactionMapper;
import io.nem.sdk.model.transaction.JsonHelper;
import io.nem.sdk.model.transaction.Transaction;
import io.nem.sdk.model.transaction.TransactionType;
import io.nem.sdk.openapi.okhttp_gson.model.EmbeddedTransactionInfoDTO;
import io.nem.sdk.openapi.okhttp_gson.model.TransactionInfoDTO;
import java.util.EnumMap;
import java.util.Map;
import org.apache.commons.lang3.Validate;

public class GeneralTransactionMapper
implements TransactionMapper {
    private final JsonHelper jsonHelper;
    private Map<TransactionType, TransactionMapper> transactionMappers = new EnumMap<TransactionType, TransactionMapper>(TransactionType.class);

    public GeneralTransactionMapper(JsonHelper jsonHelper) {
        this.jsonHelper = jsonHelper;
        Validate.notNull((Object)jsonHelper, (String)"jsonHelper must not be null", (Object[])new Object[0]);
        this.register(new AccountLinkTransactionMapper(jsonHelper));
        this.register(new AddressAliasTransactionMapper(jsonHelper));
        this.register(new HashLockTransactionMapper(jsonHelper));
        this.register(new MosaicAddressRestrictionTransactionMapper(jsonHelper));
        this.register(new MosaicAliasTransactionMapper(jsonHelper));
        this.register(new MosaicDefinitionTransactionMapper(jsonHelper));
        this.register(new MosaicGlobalRestrictionTransactionMapper(jsonHelper));
        this.register(new MosaicSupplyChangeTransactionMapper(jsonHelper));
        this.register(new MultisigAccountModificationTransactionMapper(jsonHelper));
        this.register(new NamespaceRegistrationTransactionMapper(jsonHelper));
        this.register(new SecretLockTransactionMapper(jsonHelper));
        this.register(new SecretProofTransactionMapper(jsonHelper));
        this.register(new TransferTransactionMapper(jsonHelper));
        this.register(new AccountMetadataTransactionMapper(jsonHelper));
        this.register(new MosaicMetadataTransactionMapper(jsonHelper));
        this.register(new NamespaceMetadataTransactionMapper(jsonHelper));
        this.register(new AccountAddressRestrictionTransactionMapper(jsonHelper));
        this.register(new AccountMosaicRestrictionTransactionMapper(jsonHelper));
        this.register(new AccountOperationRestrictionTransactionMapper(jsonHelper));
        this.register(new AggregateTransactionMapper(jsonHelper, TransactionType.AGGREGATE_BONDED, this));
        this.register(new AggregateTransactionMapper(jsonHelper, TransactionType.AGGREGATE_COMPLETE, this));
    }

    private void register(TransactionMapper mapper) {
        if (this.transactionMappers.put(mapper.getTransactionType(), mapper) != null) {
            throw new IllegalArgumentException("TransactionMapper for type " + mapper.getTransactionType() + " was already registered!");
        }
    }

    @Override
    public Transaction map(EmbeddedTransactionInfoDTO transactionInfoDTO) {
        Validate.notNull((Object)transactionInfoDTO, (String)"transactionInfoDTO must not be null", (Object[])new Object[0]);
        return this.resolveMapper(transactionInfoDTO).map(transactionInfoDTO);
    }

    @Override
    public Transaction map(TransactionInfoDTO transactionInfoDTO) {
        Validate.notNull((Object)transactionInfoDTO, (String)"transactionInfoDTO must not be null", (Object[])new Object[0]);
        return this.resolveMapper(transactionInfoDTO).map(transactionInfoDTO);
    }

    @Override
    public EmbeddedTransactionInfoDTO mapToEmbedded(Transaction transaction) {
        Validate.notNull((Object)transaction, (String)"transaction must not be null", (Object[])new Object[0]);
        return this.resolveMapper(transaction.getType()).mapToEmbedded(transaction);
    }

    @Override
    public TransactionInfoDTO map(Transaction transaction) {
        Validate.notNull((Object)transaction, (String)"transaction must not be null", (Object[])new Object[0]);
        return this.resolveMapper(transaction.getType()).map(transaction);
    }

    @Override
    public TransactionType getTransactionType() {
        return null;
    }

    private TransactionMapper resolveMapper(Object transactionInfoJson) {
        Integer type = this.getJsonHelper().getInteger(transactionInfoJson, new String[]{"transaction", "type"});
        if (type == null) {
            throw new IllegalArgumentException("Transaction cannot be mapped, object does not not have transaction type.");
        }
        TransactionType transactionType = TransactionType.rawValueOf((int)type);
        return this.resolveMapper(transactionType);
    }

    private TransactionMapper resolveMapper(TransactionType transactionType) {
        TransactionMapper mapper = this.transactionMappers.get(transactionType);
        if (mapper == null) {
            throw new UnsupportedOperationException("Unimplemented Transaction type " + transactionType);
        }
        return mapper;
    }

    public JsonHelper getJsonHelper() {
        return this.jsonHelper;
    }
}

