/*
 * Decompiled with CFR 0.152.
 */
package io.nem.sdk.infrastructure.okhttp.mappers;

import io.nem.sdk.infrastructure.okhttp.mappers.AbstractTransactionMapper;
import io.nem.sdk.model.account.PublicAccount;
import io.nem.sdk.model.blockchain.NetworkType;
import io.nem.sdk.model.transaction.AccountLinkAction;
import io.nem.sdk.model.transaction.AccountLinkTransaction;
import io.nem.sdk.model.transaction.AccountLinkTransactionFactory;
import io.nem.sdk.model.transaction.JsonHelper;
import io.nem.sdk.model.transaction.TransactionType;
import io.nem.sdk.openapi.okhttp_gson.model.AccountLinkActionEnum;
import io.nem.sdk.openapi.okhttp_gson.model.AccountLinkTransactionDTO;

class AccountLinkTransactionMapper
extends AbstractTransactionMapper<AccountLinkTransactionDTO, AccountLinkTransaction> {
    public AccountLinkTransactionMapper(JsonHelper jsonHelper) {
        super(jsonHelper, TransactionType.ACCOUNT_LINK, AccountLinkTransactionDTO.class);
    }

    protected AccountLinkTransactionFactory createFactory(NetworkType networkType, AccountLinkTransactionDTO dto) {
        PublicAccount remoteAccount = PublicAccount.createFromPublicKey((String)dto.getRemotePublicKey(), (NetworkType)networkType);
        return AccountLinkTransactionFactory.create((NetworkType)networkType, (PublicAccount)remoteAccount, (AccountLinkAction)AccountLinkAction.rawValueOf((int)dto.getLinkAction().getValue()));
    }

    @Override
    protected void copyToDto(AccountLinkTransaction transaction, AccountLinkTransactionDTO dto) {
        dto.setRemotePublicKey(transaction.getRemoteAccount().getPublicKey().toHex());
        dto.setLinkAction(AccountLinkActionEnum.fromValue((Integer)Integer.valueOf(transaction.getLinkAction().getValue())));
    }
}

