/*
 * Decompiled with CFR 0.152.
 */
package io.nem.sdk.infrastructure.okhttp;

import io.nem.sdk.api.ReceiptRepository;
import io.nem.sdk.infrastructure.okhttp.AbstractRepositoryOkHttpImpl;
import io.nem.sdk.infrastructure.okhttp.ReceiptMappingOkHttp;
import io.nem.sdk.model.blockchain.MerkelPathItem;
import io.nem.sdk.model.blockchain.MerkelProofInfo;
import io.nem.sdk.model.blockchain.NetworkType;
import io.nem.sdk.model.receipt.Statement;
import io.nem.sdk.openapi.okhttp_gson.api.ReceiptRoutesApi;
import io.nem.sdk.openapi.okhttp_gson.invoker.ApiClient;
import io.nem.sdk.openapi.okhttp_gson.model.MerkleProofInfoDTO;
import io.nem.sdk.openapi.okhttp_gson.model.StatementsDTO;
import io.reactivex.Observable;
import java.math.BigInteger;
import java.util.List;
import java.util.concurrent.Callable;
import java.util.stream.Collectors;

public class ReceiptRepositoryOkHttpImpl
extends AbstractRepositoryOkHttpImpl
implements ReceiptRepository {
    private final ReceiptRoutesApi client;
    private final Observable<NetworkType> networkTypeObservable;

    public ReceiptRepositoryOkHttpImpl(ApiClient apiClient, Observable<NetworkType> networkTypeObservable) {
        super(apiClient);
        this.client = new ReceiptRoutesApi(apiClient);
        this.networkTypeObservable = networkTypeObservable;
    }

    public Observable<Statement> getBlockReceipts(BigInteger height) {
        Callable<StatementsDTO> callback = () -> this.getClient().getBlockReceipts(height);
        return this.exceptionHandling(this.networkTypeObservable.flatMap(networkType -> this.call(callback).map(statementsDTO -> new ReceiptMappingOkHttp(this.getJsonHelper()).createStatementFromDto((StatementsDTO)statementsDTO, (NetworkType)networkType))));
    }

    public Observable<MerkelProofInfo> getMerkleReceipts(BigInteger height, String hash) {
        Callable<MerkleProofInfoDTO> callback = () -> this.getClient().getMerkleReceipts(height, hash);
        return this.exceptionHandling(this.call(callback).map(this::toMerkelProofInfo));
    }

    private MerkelProofInfo toMerkelProofInfo(MerkleProofInfoDTO dto) {
        List pathItems = dto.getMerklePath().stream().map(pathItem -> new MerkelPathItem(pathItem.getPosition(), pathItem.getHash())).collect(Collectors.toList());
        return new MerkelProofInfo(pathItems);
    }

    public ReceiptRoutesApi getClient() {
        return this.client;
    }
}

