/*
 * Decompiled with CFR 0.152.
 */
package io.nem.sdk.infrastructure.okhttp;

import io.nem.sdk.api.NodeRepository;
import io.nem.sdk.infrastructure.okhttp.AbstractRepositoryOkHttpImpl;
import io.nem.sdk.model.blockchain.NetworkType;
import io.nem.sdk.model.node.NodeInfo;
import io.nem.sdk.model.node.NodeTime;
import io.nem.sdk.model.node.RoleType;
import io.nem.sdk.openapi.okhttp_gson.api.NodeRoutesApi;
import io.nem.sdk.openapi.okhttp_gson.invoker.ApiClient;
import io.nem.sdk.openapi.okhttp_gson.model.NodeInfoDTO;
import io.nem.sdk.openapi.okhttp_gson.model.NodeTimeDTO;
import io.reactivex.Observable;
import java.math.BigInteger;
import java.util.concurrent.Callable;

public class NodeRepositoryOkHttpImpl
extends AbstractRepositoryOkHttpImpl
implements NodeRepository {
    private final NodeRoutesApi client;

    public NodeRepositoryOkHttpImpl(ApiClient apiClient) {
        super(apiClient);
        this.client = new NodeRoutesApi(apiClient);
    }

    public NodeRoutesApi getClient() {
        return this.client;
    }

    public Observable<NodeInfo> getNodeInfo() {
        return this.exceptionHandling(this.call(() -> ((NodeRoutesApi)this.getClient()).getNodeInfo()).map(this::toNodeInfo));
    }

    private NodeInfo toNodeInfo(NodeInfoDTO nodeInfoDTO) {
        return new NodeInfo(nodeInfoDTO.getPublicKey(), nodeInfoDTO.getPort().intValue(), NetworkType.rawValueOf((int)nodeInfoDTO.getNetworkIdentifier()), nodeInfoDTO.getVersion().intValue(), RoleType.rawValueOf((int)nodeInfoDTO.getRoles().getValue()), nodeInfoDTO.getHost(), nodeInfoDTO.getFriendlyName());
    }

    public Observable<NodeTime> getNodeTime() {
        Callable<NodeTimeDTO> callback = () -> this.getClient().getNodeTime();
        return this.exceptionHandling(this.call(callback).map(this::toNodeTime));
    }

    private NodeTime toNodeTime(NodeTimeDTO nodeTimeDTO) {
        BigInteger sendTimestamp = nodeTimeDTO.getCommunicationTimestamps().getSendTimestamp();
        BigInteger receiveTimestamp = nodeTimeDTO.getCommunicationTimestamps().getReceiveTimestamp();
        return new NodeTime(sendTimestamp, receiveTimestamp);
    }
}

