/*
 * Decompiled with CFR 0.152.
 */
package io.nem.sdk.infrastructure.okhttp;

import io.nem.sdk.api.MultisigRepository;
import io.nem.sdk.infrastructure.okhttp.AbstractRepositoryOkHttpImpl;
import io.nem.sdk.model.account.Address;
import io.nem.sdk.model.account.MultisigAccountGraphInfo;
import io.nem.sdk.model.account.MultisigAccountInfo;
import io.nem.sdk.model.account.PublicAccount;
import io.nem.sdk.model.blockchain.NetworkType;
import io.nem.sdk.openapi.okhttp_gson.api.MultisigRoutesApi;
import io.nem.sdk.openapi.okhttp_gson.invoker.ApiClient;
import io.nem.sdk.openapi.okhttp_gson.model.MultisigAccountGraphInfoDTO;
import io.nem.sdk.openapi.okhttp_gson.model.MultisigAccountInfoDTO;
import io.nem.sdk.openapi.okhttp_gson.model.MultisigDTO;
import io.reactivex.Observable;
import java.util.HashMap;
import java.util.List;
import java.util.stream.Collectors;

public class MultisigRepositoryOkHttpImpl
extends AbstractRepositoryOkHttpImpl
implements MultisigRepository {
    private final MultisigRoutesApi client;
    private final Observable<NetworkType> networkTypeObservable;

    public MultisigRepositoryOkHttpImpl(ApiClient apiClient, Observable<NetworkType> networkTypeObservable) {
        super(apiClient);
        this.client = new MultisigRoutesApi(apiClient);
        this.networkTypeObservable = networkTypeObservable;
    }

    public Observable<MultisigAccountInfo> getMultisigAccountInfo(Address address) {
        return this.exceptionHandling(this.networkTypeObservable.flatMap(networkType -> this.call(() -> this.getClient().getAccountMultisig(address.plain())).map(MultisigAccountInfoDTO::getMultisig).map(dto -> this.toMultisigAccountInfo((MultisigDTO)dto, (NetworkType)networkType))));
    }

    public Observable<MultisigAccountGraphInfo> getMultisigAccountGraphInfo(Address address) {
        return this.exceptionHandling(this.networkTypeObservable.flatMap(networkType -> this.call(() -> this.getClient().getAccountMultisigGraph(address.plain())).map(multisigAccountGraphInfoDTOList -> {
            HashMap multisigAccountInfoMap = new HashMap();
            multisigAccountGraphInfoDTOList.forEach(item -> multisigAccountInfoMap.put(item.getLevel(), this.toMultisigAccountInfo((MultisigAccountGraphInfoDTO)item, (NetworkType)networkType)));
            return new MultisigAccountGraphInfo(multisigAccountInfoMap);
        })));
    }

    private List<MultisigAccountInfo> toMultisigAccountInfo(MultisigAccountGraphInfoDTO item, NetworkType networkType) {
        return item.getMultisigEntries().stream().map(MultisigAccountInfoDTO::getMultisig).map(dto -> this.toMultisigAccountInfo((MultisigDTO)dto, networkType)).collect(Collectors.toList());
    }

    private MultisigAccountInfo toMultisigAccountInfo(MultisigDTO dto, NetworkType networkType) {
        return new MultisigAccountInfo(new PublicAccount(dto.getAccountPublicKey(), networkType), dto.getMinApproval().intValue(), dto.getMinRemoval().intValue(), dto.getCosignatoryPublicKeys().stream().map(cosigner -> new PublicAccount(cosigner, networkType)).collect(Collectors.toList()), dto.getMultisigPublicKeys().stream().map(multisigAccount -> new PublicAccount(multisigAccount, networkType)).collect(Collectors.toList()));
    }

    public MultisigRoutesApi getClient() {
        return this.client;
    }
}

