/*
 * Decompiled with CFR 0.152.
 */
package io.nem.sdk.infrastructure.okhttp;

import io.nem.core.utils.MapperUtils;
import io.nem.sdk.api.MosaicRepository;
import io.nem.sdk.infrastructure.okhttp.AbstractRepositoryOkHttpImpl;
import io.nem.sdk.model.account.Address;
import io.nem.sdk.model.account.PublicAccount;
import io.nem.sdk.model.blockchain.NetworkType;
import io.nem.sdk.model.mosaic.MosaicFlags;
import io.nem.sdk.model.mosaic.MosaicId;
import io.nem.sdk.model.mosaic.MosaicInfo;
import io.nem.sdk.openapi.okhttp_gson.api.MosaicRoutesApi;
import io.nem.sdk.openapi.okhttp_gson.invoker.ApiClient;
import io.nem.sdk.openapi.okhttp_gson.model.AccountIds;
import io.nem.sdk.openapi.okhttp_gson.model.MosaicDTO;
import io.nem.sdk.openapi.okhttp_gson.model.MosaicIds;
import io.nem.sdk.openapi.okhttp_gson.model.MosaicInfoDTO;
import io.nem.sdk.openapi.okhttp_gson.model.MosaicsInfoDTO;
import io.reactivex.Observable;
import java.math.BigInteger;
import java.util.List;
import java.util.concurrent.Callable;
import java.util.stream.Collectors;

public class MosaicRepositoryOkHttpImpl
extends AbstractRepositoryOkHttpImpl
implements MosaicRepository {
    private final MosaicRoutesApi client;
    private final Observable<NetworkType> networkTypeObservable;

    public MosaicRepositoryOkHttpImpl(ApiClient apiClient, Observable<NetworkType> networkTypeObservable) {
        super(apiClient);
        this.client = new MosaicRoutesApi(apiClient);
        this.networkTypeObservable = networkTypeObservable;
    }

    public MosaicRoutesApi getClient() {
        return this.client;
    }

    public Observable<MosaicInfo> getMosaic(MosaicId mosaicId) {
        Callable<MosaicInfoDTO> callback = () -> this.getClient().getMosaic(mosaicId.getIdAsHex());
        return this.exceptionHandling(this.networkTypeObservable.flatMap(networkType -> this.call(callback).map(mosaicInfoDTO -> this.createMosaicInfo((MosaicInfoDTO)mosaicInfoDTO, (NetworkType)networkType))));
    }

    public Observable<List<MosaicInfo>> getMosaics(List<MosaicId> ids) {
        MosaicIds mosaicIds = new MosaicIds();
        mosaicIds.mosaicIds(ids.stream().map(MosaicId::getIdAsHex).collect(Collectors.toList()));
        Callable<List> callback = () -> this.getClient().getMosaics(mosaicIds);
        return this.exceptionHandling(this.networkTypeObservable.flatMap(networkType -> this.call(callback).flatMapIterable(item -> item).map(mosaicInfoDTO -> this.createMosaicInfo((MosaicInfoDTO)mosaicInfoDTO, (NetworkType)networkType)).toList().toObservable()));
    }

    public Observable<List<MosaicInfo>> getMosaicsFromAccount(Address address) {
        Callable<MosaicsInfoDTO> callback = () -> this.getClient().getMosaicsFromAccount(address.plain());
        return this.exceptionHandling(this.networkTypeObservable.flatMap(networkType -> this.call(callback).map(MosaicsInfoDTO::getMosaics).flatMapIterable(item -> item).map(mosaicInfoDTO -> this.createMosaicInfo((MosaicDTO)mosaicInfoDTO, (NetworkType)networkType)).toList().toObservable()));
    }

    public Observable<List<MosaicInfo>> getMosaicsFromAccounts(List<Address> addresses) {
        AccountIds accountIds = new AccountIds().addresses(addresses.stream().map(Address::plain).collect(Collectors.toList()));
        Callable<MosaicsInfoDTO> callback = () -> this.getClient().getMosaicsFromAccounts(accountIds);
        return this.exceptionHandling(this.networkTypeObservable.flatMap(networkType -> this.call(callback).map(MosaicsInfoDTO::getMosaics).flatMapIterable(item -> item).map(mosaicInfoDTO -> this.createMosaicInfo((MosaicDTO)mosaicInfoDTO, (NetworkType)networkType)).toList().toObservable()));
    }

    private MosaicInfo createMosaicInfo(MosaicInfoDTO mosaicInfoDTO, NetworkType networkType) {
        return this.createMosaicInfo(mosaicInfoDTO.getMosaic(), networkType);
    }

    private MosaicInfo createMosaicInfo(MosaicDTO mosaic, NetworkType networkType) {
        return MosaicInfo.create((MosaicId)MapperUtils.toMosaicId((String)mosaic.getId()), (BigInteger)mosaic.getSupply(), (BigInteger)mosaic.getStartHeight(), (PublicAccount)new PublicAccount(mosaic.getOwnerPublicKey(), networkType), (Integer)mosaic.getRevision(), (MosaicFlags)this.extractMosaicFlags(mosaic), (int)mosaic.getDivisibility(), (BigInteger)mosaic.getDuration());
    }

    private MosaicFlags extractMosaicFlags(MosaicDTO mosaicDTO) {
        return MosaicFlags.create((int)mosaicDTO.getFlags());
    }
}

