/*
 * Decompiled with CFR 0.152.
 */
package io.nem.sdk.infrastructure.okhttp;

import io.nem.sdk.api.BlockRepository;
import io.nem.sdk.api.QueryParams;
import io.nem.sdk.infrastructure.okhttp.AbstractRepositoryOkHttpImpl;
import io.nem.sdk.infrastructure.okhttp.mappers.GeneralTransactionMapper;
import io.nem.sdk.model.blockchain.BlockInfo;
import io.nem.sdk.model.blockchain.MerkelPathItem;
import io.nem.sdk.model.blockchain.MerkelProofInfo;
import io.nem.sdk.model.blockchain.NetworkType;
import io.nem.sdk.model.transaction.Transaction;
import io.nem.sdk.openapi.okhttp_gson.api.BlockRoutesApi;
import io.nem.sdk.openapi.okhttp_gson.invoker.ApiClient;
import io.nem.sdk.openapi.okhttp_gson.model.BlockInfoDTO;
import io.nem.sdk.openapi.okhttp_gson.model.MerkleProofInfoDTO;
import io.nem.sdk.openapi.okhttp_gson.model.TransactionInfoDTO;
import io.reactivex.Observable;
import java.math.BigInteger;
import java.util.List;
import java.util.Optional;
import java.util.concurrent.Callable;
import java.util.stream.Collectors;

public class BlockRepositoryOkHttpImpl
extends AbstractRepositoryOkHttpImpl
implements BlockRepository {
    private final BlockRoutesApi client;
    private final GeneralTransactionMapper transactionMapper;

    public BlockRepositoryOkHttpImpl(ApiClient apiClient) {
        super(apiClient);
        this.client = new BlockRoutesApi(apiClient);
        this.transactionMapper = new GeneralTransactionMapper(this.getJsonHelper());
    }

    public Observable<BlockInfo> getBlockByHeight(BigInteger height) {
        Callable<BlockInfoDTO> callback = () -> this.getClient().getBlockByHeight(height);
        return this.exceptionHandling(this.call(callback).map(BlockRepositoryOkHttpImpl::toBlockInfo));
    }

    public Observable<List<Transaction>> getBlockTransactions(BigInteger height, QueryParams queryParams) {
        return this.getBlockTransactions(height, Optional.of(queryParams));
    }

    public Observable<List<Transaction>> getBlockTransactions(BigInteger height) {
        return this.getBlockTransactions(height, Optional.empty());
    }

    public Observable<List<BlockInfo>> getBlocksByHeightWithLimit(BigInteger height, int limit) {
        Callable<List> callback = () -> this.getClient().getBlocksByHeightWithLimit(height, Integer.valueOf(limit));
        return this.exceptionHandling(this.call(callback).flatMapIterable(item -> item).map(BlockRepositoryOkHttpImpl::toBlockInfo).toList().toObservable());
    }

    public Observable<MerkelProofInfo> getMerkleTransaction(BigInteger height, String hash) {
        Callable<MerkleProofInfoDTO> callback = () -> this.getClient().getMerkleTransaction(height, hash);
        return this.exceptionHandling(this.call(callback).map(this::toMerkelProofInfo));
    }

    private Observable<List<Transaction>> getBlockTransactions(BigInteger height, Optional<QueryParams> queryParams) {
        Callable<List> callback = () -> this.getClient().getBlockTransactions(height, this.getPageSize(queryParams), this.getId(queryParams), null);
        return this.exceptionHandling(this.call(callback).flatMapIterable(item -> item).map(this::toTransaction).toList().toObservable());
    }

    private MerkelProofInfo toMerkelProofInfo(MerkleProofInfoDTO dto) {
        List pathItems = dto.getMerklePath().stream().map(pathItem -> new MerkelPathItem(pathItem.getPosition(), pathItem.getHash())).collect(Collectors.toList());
        return new MerkelProofInfo(pathItems);
    }

    private Transaction toTransaction(TransactionInfoDTO input) {
        return this.transactionMapper.map(input);
    }

    public static BlockInfo toBlockInfo(BlockInfoDTO blockInfoDTO) {
        return BlockInfo.create((String)blockInfoDTO.getMeta().getHash(), (String)blockInfoDTO.getMeta().getGenerationHash(), (BigInteger)blockInfoDTO.getMeta().getTotalFee(), (Integer)blockInfoDTO.getMeta().getNumTransactions(), (List)blockInfoDTO.getMeta().getStateHashSubCacheMerkleRoots(), (String)blockInfoDTO.getBlock().getSignature(), (String)blockInfoDTO.getBlock().getSignerPublicKey(), (NetworkType)NetworkType.rawValueOf((int)blockInfoDTO.getBlock().getNetwork().getValue()), (Integer)blockInfoDTO.getBlock().getVersion(), (int)blockInfoDTO.getBlock().getType(), (BigInteger)blockInfoDTO.getBlock().getHeight(), (BigInteger)blockInfoDTO.getBlock().getTimestamp(), (BigInteger)blockInfoDTO.getBlock().getDifficulty(), (Integer)blockInfoDTO.getBlock().getFeeMultiplier(), (String)blockInfoDTO.getBlock().getPreviousBlockHash(), (String)blockInfoDTO.getBlock().getTransactionsHash(), (String)blockInfoDTO.getBlock().getReceiptsHash(), (String)blockInfoDTO.getBlock().getStateHash(), (String)blockInfoDTO.getBlock().getBeneficiaryPublicKey());
    }

    public BlockRoutesApi getClient() {
        return this.client;
    }
}

