/*
 * Decompiled with CFR 0.152.
 */
package io.nem.sdk.infrastructure.okhttp;

import io.nem.core.utils.MapperUtils;
import io.nem.sdk.api.AccountRepository;
import io.nem.sdk.api.QueryParams;
import io.nem.sdk.infrastructure.okhttp.AbstractRepositoryOkHttpImpl;
import io.nem.sdk.infrastructure.okhttp.mappers.GeneralTransactionMapper;
import io.nem.sdk.infrastructure.okhttp.mappers.TransactionMapper;
import io.nem.sdk.model.account.AccountInfo;
import io.nem.sdk.model.account.AccountType;
import io.nem.sdk.model.account.Address;
import io.nem.sdk.model.account.PublicAccount;
import io.nem.sdk.model.mosaic.Mosaic;
import io.nem.sdk.model.mosaic.UnresolvedMosaicId;
import io.nem.sdk.model.transaction.AggregateTransaction;
import io.nem.sdk.model.transaction.Transaction;
import io.nem.sdk.openapi.okhttp_gson.api.AccountRoutesApi;
import io.nem.sdk.openapi.okhttp_gson.invoker.ApiClient;
import io.nem.sdk.openapi.okhttp_gson.model.AccountDTO;
import io.nem.sdk.openapi.okhttp_gson.model.AccountIds;
import io.nem.sdk.openapi.okhttp_gson.model.AccountInfoDTO;
import io.nem.sdk.openapi.okhttp_gson.model.TransactionInfoDTO;
import io.reactivex.Observable;
import java.util.List;
import java.util.Optional;
import java.util.concurrent.Callable;
import java.util.stream.Collectors;

public class AccountRepositoryOkHttpImpl
extends AbstractRepositoryOkHttpImpl
implements AccountRepository {
    private final AccountRoutesApi client;
    private final TransactionMapper transactionMapper;

    public AccountRepositoryOkHttpImpl(ApiClient apiClient) {
        super(apiClient);
        this.client = new AccountRoutesApi(apiClient);
        this.transactionMapper = new GeneralTransactionMapper(this.getJsonHelper());
    }

    public Observable<AccountInfo> getAccountInfo(Address address) {
        Callable<AccountInfoDTO> callback = () -> this.getClient().getAccountInfo(address.plain());
        return this.exceptionHandling(this.call(callback).map(AccountInfoDTO::getAccount).map(this::toAccountInfo));
    }

    public Observable<List<AccountInfo>> getAccountsInfo(List<Address> addresses) {
        AccountIds accountIds = new AccountIds().addresses(addresses.stream().map(Address::plain).collect(Collectors.toList()));
        Callable<List> callback = () -> this.getClient().getAccountsInfo(accountIds);
        return this.exceptionHandling(this.call(callback).flatMapIterable(item -> item).map(AccountInfoDTO::getAccount).map(this::toAccountInfo).toList().toObservable());
    }

    public Observable<List<Transaction>> transactions(PublicAccount publicAccount) {
        return this.transactions(publicAccount, Optional.empty());
    }

    public Observable<List<Transaction>> transactions(PublicAccount publicAccount, QueryParams queryParams) {
        return this.transactions(publicAccount, Optional.of(queryParams));
    }

    private Observable<List<Transaction>> transactions(PublicAccount publicAccount, Optional<QueryParams> queryParams) {
        Callable<List> callback = () -> this.getClient().getAccountTransactions(publicAccount.getPublicKey().toHex(), this.getPageSize(queryParams), this.getId(queryParams), null);
        return this.exceptionHandling(this.call(callback).flatMapIterable(item -> item).map(this::toTransaction).toList().toObservable());
    }

    public Observable<List<Transaction>> incomingTransactions(PublicAccount publicAccount) {
        return this.incomingTransactions(publicAccount, Optional.empty());
    }

    public Observable<List<Transaction>> incomingTransactions(PublicAccount publicAccount, QueryParams queryParams) {
        return this.incomingTransactions(publicAccount, Optional.of(queryParams));
    }

    private Observable<List<Transaction>> incomingTransactions(PublicAccount publicAccount, Optional<QueryParams> queryParams) {
        Callable<List> callback = () -> this.getClient().getAccountIncomingTransactions(publicAccount.getPublicKey().toHex(), this.getPageSize(queryParams), this.getId(queryParams), null);
        return this.exceptionHandling(this.call(callback).flatMapIterable(item -> item).map(this::toTransaction).toList().toObservable());
    }

    public Observable<List<Transaction>> outgoingTransactions(PublicAccount publicAccount) {
        return this.outgoingTransactions(publicAccount, Optional.empty());
    }

    public Observable<List<Transaction>> outgoingTransactions(PublicAccount publicAccount, QueryParams queryParams) {
        return this.outgoingTransactions(publicAccount, Optional.of(queryParams));
    }

    private Observable<List<Transaction>> outgoingTransactions(PublicAccount publicAccount, Optional<QueryParams> queryParams) {
        Callable<List> callback = () -> this.getClient().getAccountOutgoingTransactions(publicAccount.getPublicKey().toHex(), this.getPageSize(queryParams), this.getId(queryParams), null);
        return this.exceptionHandling(this.call(callback).flatMapIterable(item -> item).map(this::toTransaction).toList().toObservable());
    }

    private Transaction toTransaction(TransactionInfoDTO input) {
        return this.transactionMapper.map(input);
    }

    public Observable<List<AggregateTransaction>> aggregateBondedTransactions(PublicAccount publicAccount) {
        return this.aggregateBondedTransactions(publicAccount, Optional.empty());
    }

    public Observable<List<AggregateTransaction>> aggregateBondedTransactions(PublicAccount publicAccount, QueryParams queryParams) {
        return this.aggregateBondedTransactions(publicAccount, Optional.of(queryParams));
    }

    private Observable<List<AggregateTransaction>> aggregateBondedTransactions(PublicAccount publicAccount, Optional<QueryParams> queryParams) {
        Callable<List> callback = () -> this.getClient().getAccountPartialTransactions(publicAccount.getPublicKey().toHex(), this.getPageSize(queryParams), this.getId(queryParams), null);
        return this.exceptionHandling(this.call(callback).flatMapIterable(item -> item).map(this::toTransaction).map(o -> (AggregateTransaction)o).toList().toObservable());
    }

    public Observable<List<Transaction>> unconfirmedTransactions(PublicAccount publicAccount) {
        return this.unconfirmedTransactions(publicAccount, Optional.empty());
    }

    public Observable<List<Transaction>> unconfirmedTransactions(PublicAccount publicAccount, QueryParams queryParams) {
        return this.unconfirmedTransactions(publicAccount, Optional.of(queryParams));
    }

    private Observable<List<Transaction>> unconfirmedTransactions(PublicAccount publicAccount, Optional<QueryParams> queryParams) {
        Callable<List> callback = () -> this.getClient().getAccountUnconfirmedTransactions(publicAccount.getPublicKey().toHex(), this.getPageSize(queryParams), this.getId(queryParams), null);
        return this.exceptionHandling(this.call(callback).flatMapIterable(item -> item).map(this::toTransaction).toList().toObservable());
    }

    private AccountInfo toAccountInfo(AccountDTO accountDTO) {
        return new AccountInfo(MapperUtils.toAddressFromEncoded((String)accountDTO.getAddress()), accountDTO.getAddressHeight(), accountDTO.getPublicKey(), accountDTO.getPublicKeyHeight(), accountDTO.getImportance(), accountDTO.getImportanceHeight(), accountDTO.getMosaics().stream().map(mosaicDTO -> new Mosaic((UnresolvedMosaicId)MapperUtils.toMosaicId((String)mosaicDTO.getId()), mosaicDTO.getAmount())).collect(Collectors.toList()), AccountType.rawValueOf((int)accountDTO.getAccountType().getValue()));
    }

    private AccountRoutesApi getClient() {
        return this.client;
    }
}

