/*
 * Decompiled with CFR 0.152.
 */
package io.nem.sdk.infrastructure.okhttp.mappers;

import io.nem.core.utils.MapperUtils;
import io.nem.sdk.infrastructure.okhttp.mappers.AbstractTransactionMapper;
import io.nem.sdk.model.blockchain.NetworkType;
import io.nem.sdk.model.mosaic.UnresolvedMosaicId;
import io.nem.sdk.model.namespace.NamespaceId;
import io.nem.sdk.model.namespace.NamespaceRegistrationType;
import io.nem.sdk.model.transaction.JsonHelper;
import io.nem.sdk.model.transaction.NamespaceRegistrationTransaction;
import io.nem.sdk.model.transaction.NamespaceRegistrationTransactionFactory;
import io.nem.sdk.model.transaction.TransactionFactory;
import io.nem.sdk.model.transaction.TransactionType;
import io.nem.sdk.openapi.okhttp_gson.model.NamespaceRegistrationTransactionDTO;
import io.nem.sdk.openapi.okhttp_gson.model.NamespaceRegistrationTypeEnum;
import java.math.BigInteger;
import java.util.Optional;

class NamespaceRegistrationTransactionMapper
extends AbstractTransactionMapper<NamespaceRegistrationTransactionDTO, NamespaceRegistrationTransaction> {
    public NamespaceRegistrationTransactionMapper(JsonHelper jsonHelper) {
        super(jsonHelper, TransactionType.REGISTER_NAMESPACE, NamespaceRegistrationTransactionDTO.class);
    }

    @Override
    protected TransactionFactory<NamespaceRegistrationTransaction> createFactory(NetworkType networkType, NamespaceRegistrationTransactionDTO transaction) {
        NamespaceRegistrationType namespaceRegistrationType = NamespaceRegistrationType.rawValueOf((int)transaction.getRegistrationType().getValue());
        return NamespaceRegistrationTransactionFactory.create((NetworkType)networkType, (String)transaction.getName(), (NamespaceId)MapperUtils.toNamespaceId((String)transaction.getId()), (NamespaceRegistrationType)namespaceRegistrationType, namespaceRegistrationType == NamespaceRegistrationType.ROOT_NAMESPACE ? Optional.of(transaction.getDuration()) : Optional.empty(), namespaceRegistrationType == NamespaceRegistrationType.SUB_NAMESPACE ? Optional.of(MapperUtils.toNamespaceId((String)transaction.getParentId())) : Optional.empty());
    }

    @Override
    protected void copyToDto(NamespaceRegistrationTransaction transaction, NamespaceRegistrationTransactionDTO dto) {
        dto.setName(transaction.getNamespaceName());
        dto.setId(MapperUtils.getIdAsHex((UnresolvedMosaicId)transaction.getNamespaceId()));
        dto.setRegistrationType(NamespaceRegistrationTypeEnum.fromValue((Integer)transaction.getNamespaceRegistrationType().getValue()));
        dto.setDuration((BigInteger)transaction.getDuration().orElse(null));
        dto.setParentId(MapperUtils.getIdAsHex((UnresolvedMosaicId)transaction.getParentId().orElse(null)));
    }
}

