/*
 * Decompiled with CFR 0.152.
 */
package io.nem.sdk.infrastructure.okhttp.mappers;

import io.nem.sdk.infrastructure.okhttp.mappers.AbstractTransactionMapper;
import io.nem.sdk.model.account.PublicAccount;
import io.nem.sdk.model.blockchain.NetworkType;
import io.nem.sdk.model.transaction.CosignatoryModificationActionType;
import io.nem.sdk.model.transaction.JsonHelper;
import io.nem.sdk.model.transaction.MultisigAccountModificationTransaction;
import io.nem.sdk.model.transaction.MultisigAccountModificationTransactionFactory;
import io.nem.sdk.model.transaction.MultisigCosignatoryModification;
import io.nem.sdk.model.transaction.TransactionType;
import io.nem.sdk.openapi.okhttp_gson.model.CosignatoryModificationActionEnum;
import io.nem.sdk.openapi.okhttp_gson.model.CosignatoryModificationDTO;
import io.nem.sdk.openapi.okhttp_gson.model.MultisigAccountModificationTransactionDTO;
import java.util.Collections;
import java.util.List;
import java.util.stream.Collectors;

class MultisigAccountModificationTransactionMapper
extends AbstractTransactionMapper<MultisigAccountModificationTransactionDTO, MultisigAccountModificationTransaction> {
    public MultisigAccountModificationTransactionMapper(JsonHelper jsonHelper) {
        super(jsonHelper, TransactionType.MODIFY_MULTISIG_ACCOUNT, MultisigAccountModificationTransactionDTO.class);
    }

    protected MultisigAccountModificationTransactionFactory createFactory(NetworkType networkType, MultisigAccountModificationTransactionDTO transaction) {
        List modifications = transaction.getModifications() == null ? Collections.emptyList() : transaction.getModifications().stream().map((? super T m) -> this.toModification(networkType, (CosignatoryModificationDTO)m)).collect(Collectors.toList());
        return MultisigAccountModificationTransactionFactory.create((NetworkType)networkType, (byte)transaction.getMinApprovalDelta().byteValue(), (byte)transaction.getMinRemovalDelta().byteValue(), modifications);
    }

    @Override
    protected void copyToDto(MultisigAccountModificationTransaction transaction, MultisigAccountModificationTransactionDTO dto) {
        dto.setMinApprovalDelta(Integer.valueOf(transaction.getMinApprovalDelta()));
        dto.setMinRemovalDelta(Integer.valueOf(transaction.getMinRemovalDelta()));
        dto.setModifications(transaction.getModifications().stream().map(this::toModification).collect(Collectors.toList()));
    }

    private MultisigCosignatoryModification toModification(NetworkType networkType, CosignatoryModificationDTO dto) {
        return new MultisigCosignatoryModification(CosignatoryModificationActionType.rawValueOf((int)dto.getModificationAction().getValue()), PublicAccount.createFromPublicKey((String)dto.getCosignatoryPublicKey(), (NetworkType)networkType));
    }

    private CosignatoryModificationDTO toModification(MultisigCosignatoryModification model) {
        CosignatoryModificationDTO dto = new CosignatoryModificationDTO();
        dto.setModificationAction(CosignatoryModificationActionEnum.fromValue((Integer)model.getModificationAction().getValue()));
        dto.setCosignatoryPublicKey(model.getCosignatoryPublicAccount().getPublicKey().toHex());
        return dto;
    }
}

