/*
 * Decompiled with CFR 0.152.
 */
package io.nem.sdk.infrastructure.okhttp.mappers;

import io.nem.core.utils.MapperUtils;
import io.nem.sdk.infrastructure.okhttp.mappers.AbstractTransactionMapper;
import io.nem.sdk.model.blockchain.NetworkType;
import io.nem.sdk.model.mosaic.MosaicSupplyChangeActionType;
import io.nem.sdk.model.mosaic.UnresolvedMosaicId;
import io.nem.sdk.model.transaction.JsonHelper;
import io.nem.sdk.model.transaction.MosaicSupplyChangeTransaction;
import io.nem.sdk.model.transaction.MosaicSupplyChangeTransactionFactory;
import io.nem.sdk.model.transaction.TransactionFactory;
import io.nem.sdk.model.transaction.TransactionType;
import io.nem.sdk.openapi.okhttp_gson.model.MosaicSupplyChangeActionEnum;
import io.nem.sdk.openapi.okhttp_gson.model.MosaicSupplyChangeTransactionDTO;
import java.math.BigInteger;

class MosaicSupplyChangeTransactionMapper
extends AbstractTransactionMapper<MosaicSupplyChangeTransactionDTO, MosaicSupplyChangeTransaction> {
    public MosaicSupplyChangeTransactionMapper(JsonHelper jsonHelper) {
        super(jsonHelper, TransactionType.MOSAIC_SUPPLY_CHANGE, MosaicSupplyChangeTransactionDTO.class);
    }

    @Override
    protected TransactionFactory<MosaicSupplyChangeTransaction> createFactory(NetworkType networkType, MosaicSupplyChangeTransactionDTO transaction) {
        return MosaicSupplyChangeTransactionFactory.create((NetworkType)networkType, (UnresolvedMosaicId)MapperUtils.toMosaicId((String)transaction.getMosaicId()), (MosaicSupplyChangeActionType)MosaicSupplyChangeActionType.rawValueOf((int)transaction.getAction().getValue()), (BigInteger)transaction.getDelta());
    }

    @Override
    protected void copyToDto(MosaicSupplyChangeTransaction transaction, MosaicSupplyChangeTransactionDTO dto) {
        dto.setDelta(transaction.getDelta());
        dto.setMosaicId(MapperUtils.getIdAsHex((UnresolvedMosaicId)transaction.getMosaicId()));
        dto.setAction(MosaicSupplyChangeActionEnum.fromValue((Integer)transaction.getAction().getValue()));
    }
}

