/*
 * Decompiled with CFR 0.152.
 */
package io.nem.sdk.infrastructure.okhttp.mappers;

import io.nem.core.utils.MapperUtils;
import io.nem.sdk.infrastructure.okhttp.mappers.AbstractTransactionMapper;
import io.nem.sdk.model.blockchain.BlockDuration;
import io.nem.sdk.model.blockchain.NetworkType;
import io.nem.sdk.model.mosaic.MosaicFlags;
import io.nem.sdk.model.mosaic.MosaicId;
import io.nem.sdk.model.mosaic.MosaicNonce;
import io.nem.sdk.model.mosaic.UnresolvedMosaicId;
import io.nem.sdk.model.transaction.JsonHelper;
import io.nem.sdk.model.transaction.MosaicDefinitionTransaction;
import io.nem.sdk.model.transaction.MosaicDefinitionTransactionFactory;
import io.nem.sdk.model.transaction.TransactionFactory;
import io.nem.sdk.model.transaction.TransactionType;
import io.nem.sdk.openapi.okhttp_gson.model.MosaicDefinitionTransactionDTO;
import java.math.BigInteger;

class MosaicDefinitionTransactionMapper
extends AbstractTransactionMapper<MosaicDefinitionTransactionDTO, MosaicDefinitionTransaction> {
    public MosaicDefinitionTransactionMapper(JsonHelper jsonHelper) {
        super(jsonHelper, TransactionType.MOSAIC_DEFINITION, MosaicDefinitionTransactionDTO.class);
    }

    @Override
    protected TransactionFactory<MosaicDefinitionTransaction> createFactory(NetworkType networkType, MosaicDefinitionTransactionDTO transaction) {
        MosaicFlags mosaicFlags = MosaicFlags.create((int)transaction.getFlags());
        return MosaicDefinitionTransactionFactory.create((NetworkType)networkType, (MosaicNonce)MosaicNonce.createFromBigInteger((Long)transaction.getNonce()), (MosaicId)MapperUtils.toMosaicId((String)transaction.getId()), (MosaicFlags)mosaicFlags, (int)transaction.getDivisibility(), (BlockDuration)new BlockDuration(transaction.getDuration()));
    }

    @Override
    protected void copyToDto(MosaicDefinitionTransaction transaction, MosaicDefinitionTransactionDTO dto) {
        dto.setFlags(Integer.valueOf(transaction.getMosaicFlags().getValue()));
        dto.setId(MapperUtils.getIdAsHex((UnresolvedMosaicId)transaction.getMosaicId()));
        dto.setDivisibility(Integer.valueOf(transaction.getDivisibility()));
        dto.setNonce(Long.valueOf(transaction.getMosaicNonce().getNonceAsInt()));
        dto.setDuration(BigInteger.valueOf(transaction.getBlockDuration().getDuration()));
    }
}

