/*
 * Decompiled with CFR 0.152.
 */
package io.nem.sdk.infrastructure.okhttp.mappers;

import io.nem.sdk.infrastructure.okhttp.mappers.AbstractTransactionMapper;
import io.nem.sdk.infrastructure.okhttp.mappers.TransactionMapper;
import io.nem.sdk.model.account.PublicAccount;
import io.nem.sdk.model.blockchain.NetworkType;
import io.nem.sdk.model.transaction.AggregateTransaction;
import io.nem.sdk.model.transaction.AggregateTransactionCosignature;
import io.nem.sdk.model.transaction.AggregateTransactionFactory;
import io.nem.sdk.model.transaction.JsonHelper;
import io.nem.sdk.model.transaction.Transaction;
import io.nem.sdk.model.transaction.TransactionType;
import io.nem.sdk.openapi.okhttp_gson.model.AggregateBondedTransactionDTO;
import io.nem.sdk.openapi.okhttp_gson.model.CosignatureDTO;
import io.nem.sdk.openapi.okhttp_gson.model.EmbeddedTransactionInfoDTO;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;

class AggregateTransactionMapper
extends AbstractTransactionMapper<AggregateBondedTransactionDTO, AggregateTransaction> {
    private TransactionMapper transactionMapper;

    public AggregateTransactionMapper(JsonHelper jsonHelper, TransactionType transactionType, TransactionMapper transactionMapper) {
        super(jsonHelper, transactionType, AggregateBondedTransactionDTO.class);
        this.transactionMapper = transactionMapper;
    }

    protected AggregateTransactionFactory createFactory(NetworkType networkType, AggregateBondedTransactionDTO transaction) {
        List transactions = transaction.getTransactions().stream().map((? super T embeddedTransactionInfoDTO) -> {
            EmbeddedTransactionInfoDTO transactionInfoDTO = new EmbeddedTransactionInfoDTO();
            transactionInfoDTO.setMeta(embeddedTransactionInfoDTO.getMeta());
            transactionInfoDTO.setTransaction(embeddedTransactionInfoDTO.getTransaction());
            Map innerTransaction = (Map)embeddedTransactionInfoDTO.getTransaction();
            innerTransaction.put("deadline", transaction.getDeadline());
            innerTransaction.put("maxFee", transaction.getMaxFee());
            innerTransaction.put("signature", transaction.getSignature());
            return this.transactionMapper.map(transactionInfoDTO);
        }).collect(Collectors.toList());
        List<Object> cosignatures = new ArrayList();
        if (transaction.getCosignatures() != null) {
            cosignatures = transaction.getCosignatures().stream().map((? super T aggregateCosignature) -> this.toCosignature(networkType, (CosignatureDTO)aggregateCosignature)).collect(Collectors.toList());
        }
        return AggregateTransactionFactory.create((TransactionType)this.getTransactionType(), (NetworkType)networkType, transactions, cosignatures);
    }

    private AggregateTransactionCosignature toCosignature(NetworkType networkType, CosignatureDTO aggregateCosignature) {
        return new AggregateTransactionCosignature(aggregateCosignature.getSignature(), PublicAccount.createFromPublicKey((String)aggregateCosignature.getSignerPublicKey(), (NetworkType)networkType));
    }

    @Override
    protected void copyToDto(AggregateTransaction transaction, AggregateBondedTransactionDTO dto) {
        List transactions = transaction.getInnerTransactions().stream().map((? super T embeddedTransactionInfoDTO) -> this.transactionMapper.mapToEmbedded((Transaction)embeddedTransactionInfoDTO)).collect(Collectors.toList());
        List<Object> cosignatures = new ArrayList();
        if (transaction.getCosignatures() != null) {
            cosignatures = transaction.getCosignatures().stream().map(this::toCosignature).collect(Collectors.toList());
        }
        dto.setCosignatures(cosignatures);
        dto.setTransactions(transactions);
    }

    private CosignatureDTO toCosignature(AggregateTransactionCosignature aggregateCosignature) {
        CosignatureDTO cosignatureDTO = new CosignatureDTO();
        cosignatureDTO.setSignerPublicKey(aggregateCosignature.getSigner().getPublicKey().toHex());
        cosignatureDTO.setSignature(aggregateCosignature.getSignature());
        return cosignatureDTO;
    }
}

