/*
 * Decompiled with CFR 0.152.
 */
package io.nem.sdk.infrastructure.okhttp.mappers;

import io.nem.sdk.infrastructure.okhttp.mappers.AbstractTransactionMapper;
import io.nem.sdk.model.blockchain.NetworkType;
import io.nem.sdk.model.transaction.AccountOperationRestrictionTransaction;
import io.nem.sdk.model.transaction.AccountOperationRestrictionTransactionFactory;
import io.nem.sdk.model.transaction.AccountRestrictionModification;
import io.nem.sdk.model.transaction.AccountRestrictionModificationAction;
import io.nem.sdk.model.transaction.AccountRestrictionType;
import io.nem.sdk.model.transaction.JsonHelper;
import io.nem.sdk.model.transaction.TransactionType;
import io.nem.sdk.openapi.okhttp_gson.model.AccountOperationRestrictionModificationDTO;
import io.nem.sdk.openapi.okhttp_gson.model.AccountOperationRestrictionTransactionDTO;
import io.nem.sdk.openapi.okhttp_gson.model.AccountRestrictionModificationActionEnum;
import io.nem.sdk.openapi.okhttp_gson.model.AccountRestrictionTypeEnum;
import io.nem.sdk.openapi.okhttp_gson.model.TransactionTypeEnum;
import java.util.List;
import java.util.stream.Collectors;

public class AccountOperationRestrictionTransactionMapper
extends AbstractTransactionMapper<AccountOperationRestrictionTransactionDTO, AccountOperationRestrictionTransaction> {
    public AccountOperationRestrictionTransactionMapper(JsonHelper jsonHelper) {
        super(jsonHelper, TransactionType.ACCOUNT_OPERATION_RESTRICTION, AccountOperationRestrictionTransactionDTO.class);
    }

    protected AccountOperationRestrictionTransactionFactory createFactory(NetworkType networkType, AccountOperationRestrictionTransactionDTO transaction) {
        AccountRestrictionType restrictionType = AccountRestrictionType.rawValueOf((int)transaction.getRestrictionType().getValue());
        List modifications = transaction.getModifications().stream().map(this::toModification).collect(Collectors.toList());
        return AccountOperationRestrictionTransactionFactory.create((NetworkType)networkType, (AccountRestrictionType)restrictionType, modifications);
    }

    private AccountRestrictionModification<TransactionType> toModification(AccountOperationRestrictionModificationDTO dto) {
        AccountRestrictionModificationAction modificationAction = AccountRestrictionModificationAction.rawValueOf((byte)dto.getModificationAction().getValue().byteValue());
        return AccountRestrictionModification.createForTransactionType((AccountRestrictionModificationAction)modificationAction, (TransactionType)TransactionType.rawValueOf((int)dto.getValue().getValue()));
    }

    @Override
    protected void copyToDto(AccountOperationRestrictionTransaction transaction, AccountOperationRestrictionTransactionDTO dto) {
        dto.setRestrictionType(AccountRestrictionTypeEnum.fromValue((Integer)transaction.getRestrictionType().getValue()));
        dto.setModifications(transaction.getModifications().stream().map(this::toModification).collect(Collectors.toList()));
    }

    private AccountOperationRestrictionModificationDTO toModification(AccountRestrictionModification<TransactionType> model) {
        AccountOperationRestrictionModificationDTO dto = new AccountOperationRestrictionModificationDTO();
        dto.setModificationAction(AccountRestrictionModificationActionEnum.fromValue((Integer)Integer.valueOf(model.getModificationAction().getValue())));
        dto.setValue(TransactionTypeEnum.fromValue((Integer)((TransactionType)model.getValue()).getValue()));
        return dto;
    }
}

