/*
 * Decompiled with CFR 0.152.
 */
package io.nem.sdk.infrastructure.okhttp.mappers;

import io.nem.core.utils.MapperUtils;
import io.nem.sdk.infrastructure.okhttp.mappers.AbstractTransactionMapper;
import io.nem.sdk.model.account.UnresolvedAddress;
import io.nem.sdk.model.blockchain.NetworkType;
import io.nem.sdk.model.transaction.AccountAddressRestrictionTransaction;
import io.nem.sdk.model.transaction.AccountAddressRestrictionTransactionFactory;
import io.nem.sdk.model.transaction.AccountRestrictionModification;
import io.nem.sdk.model.transaction.AccountRestrictionModificationAction;
import io.nem.sdk.model.transaction.AccountRestrictionType;
import io.nem.sdk.model.transaction.JsonHelper;
import io.nem.sdk.model.transaction.TransactionType;
import io.nem.sdk.openapi.okhttp_gson.model.AccountAddressRestrictionModificationDTO;
import io.nem.sdk.openapi.okhttp_gson.model.AccountAddressRestrictionTransactionDTO;
import io.nem.sdk.openapi.okhttp_gson.model.AccountRestrictionModificationActionEnum;
import io.nem.sdk.openapi.okhttp_gson.model.AccountRestrictionTypeEnum;
import java.util.List;
import java.util.stream.Collectors;

public class AccountAddressRestrictionTransactionMapper
extends AbstractTransactionMapper<AccountAddressRestrictionTransactionDTO, AccountAddressRestrictionTransaction> {
    public AccountAddressRestrictionTransactionMapper(JsonHelper jsonHelper) {
        super(jsonHelper, TransactionType.ACCOUNT_ADDRESS_RESTRICTION, AccountAddressRestrictionTransactionDTO.class);
    }

    protected AccountAddressRestrictionTransactionFactory createFactory(NetworkType networkType, AccountAddressRestrictionTransactionDTO transaction) {
        AccountRestrictionType restrictionType = AccountRestrictionType.rawValueOf((int)transaction.getRestrictionType().getValue());
        List modifications = transaction.getModifications().stream().map(this::toModification).collect(Collectors.toList());
        return AccountAddressRestrictionTransactionFactory.create((NetworkType)networkType, (AccountRestrictionType)restrictionType, modifications);
    }

    private AccountRestrictionModification<UnresolvedAddress> toModification(AccountAddressRestrictionModificationDTO dto) {
        AccountRestrictionModificationAction modificationAction = AccountRestrictionModificationAction.rawValueOf((byte)dto.getModificationAction().getValue().byteValue());
        return AccountRestrictionModification.createForAddress((AccountRestrictionModificationAction)modificationAction, (UnresolvedAddress)MapperUtils.toUnresolvedAddress((String)dto.getValue()));
    }

    @Override
    protected void copyToDto(AccountAddressRestrictionTransaction transaction, AccountAddressRestrictionTransactionDTO dto) {
        dto.setRestrictionType(AccountRestrictionTypeEnum.fromValue((Integer)transaction.getRestrictionType().getValue()));
        dto.setModifications(transaction.getModifications().stream().map(this::toModification).collect(Collectors.toList()));
    }

    private AccountAddressRestrictionModificationDTO toModification(AccountRestrictionModification<UnresolvedAddress> source) {
        AccountRestrictionModificationActionEnum modificationAction = AccountRestrictionModificationActionEnum.fromValue((Integer)Integer.valueOf(source.getModificationAction().getValue()));
        AccountAddressRestrictionModificationDTO target = new AccountAddressRestrictionModificationDTO();
        target.setModificationAction(modificationAction);
        target.setValue(((UnresolvedAddress)source.getValue()).encoded());
        return target;
    }
}

