/*
 * Decompiled with CFR 0.152.
 */
package io.nem.sdk.infrastructure.okhttp;

import io.nem.sdk.api.AccountRepository;
import io.nem.sdk.api.BlockRepository;
import io.nem.sdk.api.ChainRepository;
import io.nem.sdk.api.DiagnosticRepository;
import io.nem.sdk.api.JsonSerialization;
import io.nem.sdk.api.MetadataRepository;
import io.nem.sdk.api.MosaicRepository;
import io.nem.sdk.api.NamespaceRepository;
import io.nem.sdk.api.NetworkRepository;
import io.nem.sdk.api.NodeRepository;
import io.nem.sdk.api.RepositoryFactory;
import io.nem.sdk.api.RestrictionRepository;
import io.nem.sdk.api.TransactionRepository;
import io.nem.sdk.infrastructure.Listener;
import io.nem.sdk.infrastructure.okhttp.AccountRepositoryOkHttpImpl;
import io.nem.sdk.infrastructure.okhttp.BlockRepositoryOkHttpImpl;
import io.nem.sdk.infrastructure.okhttp.ChainRepositoryOkHttpImpl;
import io.nem.sdk.infrastructure.okhttp.DiagnosticRepositoryOkHttpImpl;
import io.nem.sdk.infrastructure.okhttp.JsonHelperGson;
import io.nem.sdk.infrastructure.okhttp.JsonSerializationOkHttp;
import io.nem.sdk.infrastructure.okhttp.ListenerOkHttp;
import io.nem.sdk.infrastructure.okhttp.MetadataRepositoryOkHttpImpl;
import io.nem.sdk.infrastructure.okhttp.MosaicRepositoryOkHttpImpl;
import io.nem.sdk.infrastructure.okhttp.NamespaceRepositoryOkHttpImpl;
import io.nem.sdk.infrastructure.okhttp.NetworkRepositoryOkHttpImpl;
import io.nem.sdk.infrastructure.okhttp.NodeRepositoryOkHttpImpl;
import io.nem.sdk.infrastructure.okhttp.RestrictionRepositoryOkHttpImpl;
import io.nem.sdk.infrastructure.okhttp.TransactionRepositoryOkHttpImpl;
import io.nem.sdk.openapi.okhttp_gson.invoker.ApiClient;
import java.io.Closeable;
import okhttp3.OkHttpClient;
import org.apache.commons.io.IOUtils;

public class RepositoryFactoryOkHttpImpl
implements RepositoryFactory {
    private final ApiClient apiClient;
    private final String baseUrl;

    public RepositoryFactoryOkHttpImpl(String baseUrl) {
        this.baseUrl = baseUrl;
        this.apiClient = new ApiClient();
        this.apiClient.setBasePath(baseUrl);
        this.apiClient.getJSON().setGson(JsonHelperGson.creatGson(false));
    }

    public AccountRepository createAccountRepository() {
        return new AccountRepositoryOkHttpImpl(this.apiClient);
    }

    public BlockRepository createBlockRepository() {
        return new BlockRepositoryOkHttpImpl(this.apiClient);
    }

    public ChainRepository createChainRepository() {
        return new ChainRepositoryOkHttpImpl(this.apiClient);
    }

    public DiagnosticRepository createDiagnosticRepository() {
        return new DiagnosticRepositoryOkHttpImpl(this.apiClient);
    }

    public MosaicRepository createMosaicRepository() {
        return new MosaicRepositoryOkHttpImpl(this.apiClient);
    }

    public NamespaceRepository createNamespaceRepository() {
        return new NamespaceRepositoryOkHttpImpl(this.apiClient);
    }

    public NetworkRepository createNetworkRepository() {
        return new NetworkRepositoryOkHttpImpl(this.apiClient);
    }

    public NodeRepository createNodeRepository() {
        return new NodeRepositoryOkHttpImpl(this.apiClient);
    }

    public TransactionRepository createTransactionRepository() {
        return new TransactionRepositoryOkHttpImpl(this.apiClient);
    }

    public MetadataRepository createMetadataRepository() {
        return new MetadataRepositoryOkHttpImpl(this.apiClient);
    }

    public RestrictionRepository createRestrictionRepository() {
        return new RestrictionRepositoryOkHttpImpl(this.apiClient);
    }

    public Listener createListener() {
        return new ListenerOkHttp(this.apiClient.getHttpClient(), this.baseUrl, this.apiClient.getJSON());
    }

    public JsonSerialization createJsonSerialization() {
        return new JsonSerializationOkHttp(this.apiClient.getJSON().getGson());
    }

    public void close() {
        OkHttpClient client = this.apiClient.getHttpClient();
        client.dispatcher().executorService().shutdown();
        client.connectionPool().evictAll();
        IOUtils.closeQuietly((Closeable)client.cache());
    }
}

