/*
 * Decompiled with CFR 0.152.
 */
package io.nem.sdk.infrastructure.okhttp;

import io.nem.sdk.api.NetworkRepository;
import io.nem.sdk.infrastructure.okhttp.AbstractRepositoryOkHttpImpl;
import io.nem.sdk.model.blockchain.NetworkType;
import io.nem.sdk.openapi.okhttp_gson.api.NetworkRoutesApi;
import io.nem.sdk.openapi.okhttp_gson.invoker.ApiClient;
import io.nem.sdk.openapi.okhttp_gson.model.NetworkTypeDTO;
import io.reactivex.Observable;

public class NetworkRepositoryOkHttpImpl
extends AbstractRepositoryOkHttpImpl
implements NetworkRepository {
    private final NetworkRoutesApi client;

    public NetworkRepositoryOkHttpImpl(ApiClient apiClient) {
        super(apiClient);
        this.client = new NetworkRoutesApi(apiClient);
    }

    public Observable<NetworkType> getNetworkType() {
        return this.exceptionHandling(this.call(() -> ((NetworkRoutesApi)this.getClient()).getNetworkType()).map(NetworkTypeDTO::getName).map(this::getNetworkType));
    }

    private NetworkType getNetworkType(String name) {
        if ("mijinTest".equalsIgnoreCase(name)) {
            return NetworkType.MIJIN_TEST;
        }
        throw new IllegalArgumentException("network " + name + " is not supported yet by the sdk");
    }

    public NetworkRoutesApi getClient() {
        return this.client;
    }
}

