/*
 * Decompiled with CFR 0.152.
 */
package io.nem.sdk.infrastructure.okhttp;

import io.nem.core.utils.MapperUtils;
import io.nem.sdk.api.MosaicRepository;
import io.nem.sdk.infrastructure.okhttp.AbstractRepositoryOkHttpImpl;
import io.nem.sdk.model.account.PublicAccount;
import io.nem.sdk.model.blockchain.NetworkType;
import io.nem.sdk.model.mosaic.MosaicFlags;
import io.nem.sdk.model.mosaic.MosaicId;
import io.nem.sdk.model.mosaic.MosaicInfo;
import io.nem.sdk.model.mosaic.MosaicNames;
import io.nem.sdk.model.namespace.NamespaceName;
import io.nem.sdk.openapi.okhttp_gson.api.MosaicRoutesApi;
import io.nem.sdk.openapi.okhttp_gson.invoker.ApiClient;
import io.nem.sdk.openapi.okhttp_gson.model.MosaicDTO;
import io.nem.sdk.openapi.okhttp_gson.model.MosaicIds;
import io.nem.sdk.openapi.okhttp_gson.model.MosaicInfoDTO;
import io.nem.sdk.openapi.okhttp_gson.model.MosaicNamesDTO;
import io.nem.sdk.openapi.okhttp_gson.model.MosaicsNamesDTO;
import io.reactivex.Observable;
import java.math.BigInteger;
import java.util.List;
import java.util.concurrent.Callable;
import java.util.stream.Collectors;

public class MosaicRepositoryOkHttpImpl
extends AbstractRepositoryOkHttpImpl
implements MosaicRepository {
    private final MosaicRoutesApi client;

    public MosaicRepositoryOkHttpImpl(ApiClient apiClient) {
        super(apiClient);
        this.client = new MosaicRoutesApi(apiClient);
    }

    public MosaicRoutesApi getClient() {
        return this.client;
    }

    public Observable<MosaicInfo> getMosaic(MosaicId mosaicId) {
        Callable<MosaicInfoDTO> callback = () -> this.getClient().getMosaic(mosaicId.getIdAsHex());
        return this.exceptionHandling(this.call(callback).map(this::createMosaicInfo));
    }

    public Observable<List<MosaicInfo>> getMosaics(List<MosaicId> ids) {
        MosaicIds mosaicIds = new MosaicIds();
        mosaicIds.mosaicIds(ids.stream().map(MosaicId::getIdAsHex).collect(Collectors.toList()));
        Callable<List> callback = () -> this.getClient().getMosaics(mosaicIds);
        return this.exceptionHandling(this.call(callback).flatMapIterable(item -> item).map(this::createMosaicInfo).toList().toObservable());
    }

    public Observable<List<MosaicNames>> getMosaicsNames(List<MosaicId> ids) {
        MosaicIds mosaicIds = new MosaicIds();
        mosaicIds.mosaicIds(ids.stream().map(MosaicId::getIdAsHex).collect(Collectors.toList()));
        Callable<MosaicsNamesDTO> callback = () -> this.getClient().getMosaicsNames(mosaicIds);
        return this.exceptionHandling(this.call(callback).map(MosaicsNamesDTO::getMosaicNames).flatMapIterable(item -> item).map(this::toMosaicNames).toList().toObservable());
    }

    private MosaicNames toMosaicNames(MosaicNamesDTO dto) {
        return new MosaicNames(MapperUtils.toMosaicId((String)dto.getMosaicId()), dto.getNames().stream().map(NamespaceName::new).collect(Collectors.toList()));
    }

    private MosaicInfo createMosaicInfo(MosaicInfoDTO mosaicInfoDTO) {
        NetworkType networkType = this.getNetworkTypeBlocking();
        return MosaicInfo.create((MosaicId)MapperUtils.toMosaicId((String)mosaicInfoDTO.getMosaic().getId()), (BigInteger)mosaicInfoDTO.getMosaic().getSupply(), (BigInteger)mosaicInfoDTO.getMosaic().getStartHeight(), (PublicAccount)new PublicAccount(mosaicInfoDTO.getMosaic().getOwnerPublicKey(), networkType), (Integer)mosaicInfoDTO.getMosaic().getRevision(), (MosaicFlags)this.extractMosaicFlags(mosaicInfoDTO.getMosaic()), (int)mosaicInfoDTO.getMosaic().getDivisibility(), (BigInteger)mosaicInfoDTO.getMosaic().getDuration());
    }

    private MosaicFlags extractMosaicFlags(MosaicDTO mosaicDTO) {
        return MosaicFlags.create((int)mosaicDTO.getFlags());
    }
}

