/*
 * Decompiled with CFR 0.152.
 */
package io.nem.sdk.infrastructure.okhttp;

import io.nem.core.utils.ConvertUtils;
import io.nem.sdk.api.MetadataRepository;
import io.nem.sdk.api.QueryParams;
import io.nem.sdk.infrastructure.okhttp.AbstractRepositoryOkHttpImpl;
import io.nem.sdk.model.account.Address;
import io.nem.sdk.model.metadata.Metadata;
import io.nem.sdk.model.metadata.MetadataEntry;
import io.nem.sdk.model.metadata.MetadataType;
import io.nem.sdk.model.mosaic.MosaicId;
import io.nem.sdk.model.namespace.NamespaceId;
import io.nem.sdk.openapi.okhttp_gson.api.MetadataRoutesApi;
import io.nem.sdk.openapi.okhttp_gson.invoker.ApiClient;
import io.nem.sdk.openapi.okhttp_gson.model.MetadataDTO;
import io.nem.sdk.openapi.okhttp_gson.model.MetadataEntriesDTO;
import io.nem.sdk.openapi.okhttp_gson.model.MetadataEntryDTO;
import io.reactivex.Observable;
import java.math.BigInteger;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.concurrent.Callable;

public class MetadataRepositoryOkHttpImpl
extends AbstractRepositoryOkHttpImpl
implements MetadataRepository {
    private final MetadataRoutesApi client;

    public MetadataRepositoryOkHttpImpl(ApiClient apiClient) {
        super(apiClient);
        this.client = new MetadataRoutesApi(apiClient);
    }

    public Observable<List<Metadata>> getAccountMetadata(Address address, Optional<QueryParams> queryParams) {
        Callable<MetadataEntriesDTO> callback = () -> this.getClient().getAccountMetadata(address.plain(), this.getPageSize(queryParams), this.getId(queryParams), this.getOrder(queryParams));
        return this.handleList(callback);
    }

    public Observable<List<Metadata>> getAccountMetadataByKey(Address address, BigInteger key) {
        Callable<MetadataEntriesDTO> callback = () -> this.getClient().getAccountMetadataByKey(address.plain(), this.toHex(key));
        return this.handleList(callback);
    }

    public Observable<List<Metadata>> getMosaicMetadata(MosaicId mosaicId, Optional<QueryParams> queryParams) {
        Callable<MetadataEntriesDTO> callback = () -> this.getClient().getMosaicMetadata(mosaicId.getIdAsHex(), this.getPageSize(queryParams), this.getId(queryParams), this.getOrder(queryParams));
        return this.handleList(callback);
    }

    public Observable<List<Metadata>> getMosaicMetadataByKey(MosaicId mosaicId, BigInteger key) {
        Callable<MetadataEntriesDTO> callback = () -> this.getClient().getMosaicMetadataByKey(mosaicId.getIdAsHex(), this.toHex(key));
        return this.handleList(callback);
    }

    public Observable<Metadata> getAccountMetadataByKeyAndSender(Address address, BigInteger key, String publicKey) {
        Callable<MetadataDTO> callback = () -> this.getClient().getAccountMetadataByKeyAndSender(address.plain(), this.toHex(key), publicKey);
        return this.handleOne(callback);
    }

    public Observable<Metadata> getMosaicMetadataByKeyAndSender(MosaicId mosaicId, BigInteger key, String publicKey) {
        Callable<MetadataDTO> callback = () -> this.getClient().getMosaicMetadataByKeyAndSender(mosaicId.getIdAsHex(), this.toHex(key), publicKey);
        return this.handleOne(callback);
    }

    public Observable<List<Metadata>> getNamespaceMetadata(NamespaceId namespaceId, Optional<QueryParams> queryParams) {
        Callable<MetadataEntriesDTO> callback = () -> this.getClient().getNamespaceMetadata(namespaceId.getIdAsHex(), this.getPageSize(queryParams), this.getId(queryParams), this.getOrder(queryParams));
        return this.handleList(callback);
    }

    public Observable<List<Metadata>> getNamespaceMetadataByKey(NamespaceId namespaceId, BigInteger key) {
        Callable<MetadataEntriesDTO> callback = () -> this.getClient().getNamespaceMetadataByKey(namespaceId.getIdAsHex(), this.toHex(key));
        return this.handleList(callback);
    }

    public Observable<Metadata> getNamespaceMetadataByKeyAndSender(NamespaceId namespaceId, BigInteger key, String publicKey) {
        Callable<MetadataDTO> callback = () -> this.getClient().getNamespaceMetadataByKeyAndSender(namespaceId.getIdAsHex(), this.toHex(key), publicKey);
        return this.handleOne(callback);
    }

    public MetadataRoutesApi getClient() {
        return this.client;
    }

    private Observable<List<Metadata>> handleList(Callable<MetadataEntriesDTO> callback) {
        return this.exceptionHandling(this.call(callback).map(MetadataEntriesDTO::getMetadataEntries).flatMapIterable(item -> item).map(this::toMetadata).toList().toObservable());
    }

    private Observable<Metadata> handleOne(Callable<MetadataDTO> callback) {
        return this.exceptionHandling(this.call(callback).map(this::toMetadata));
    }

    private Metadata toMetadata(MetadataDTO dto) {
        MetadataEntryDTO entryDto = dto.getMetadataEntry();
        MetadataEntry metadataEntry = new MetadataEntry(entryDto.getCompositeHash(), entryDto.getSenderPublicKey(), entryDto.getTargetPublicKey(), new BigInteger(entryDto.getScopedMetadataKey(), 16), MetadataType.rawValueOf((int)entryDto.getMetadataType().getValue()), entryDto.getValueSize(), ConvertUtils.fromHexToString((String)entryDto.getValue()), Optional.ofNullable(Objects.toString(entryDto.getTargetId(), null)));
        return new Metadata(dto.getId(), metadataEntry);
    }

    private String toHex(BigInteger key) {
        return ConvertUtils.toSize16Hex((BigInteger)key);
    }
}

