/*
 * Decompiled with CFR 0.152.
 */
package io.nem.sdk.infrastructure.okhttp;

import com.google.gson.JsonObject;
import io.nem.sdk.infrastructure.Listener;
import io.nem.sdk.infrastructure.ListenerBase;
import io.nem.sdk.infrastructure.ListenerSubscribeMessage;
import io.nem.sdk.infrastructure.okhttp.BlockRepositoryOkHttpImpl;
import io.nem.sdk.infrastructure.okhttp.JsonHelperGson;
import io.nem.sdk.infrastructure.okhttp.mappers.GeneralTransactionMapper;
import io.nem.sdk.infrastructure.okhttp.mappers.TransactionMapper;
import io.nem.sdk.model.blockchain.BlockInfo;
import io.nem.sdk.model.transaction.JsonHelper;
import io.nem.sdk.model.transaction.Transaction;
import io.nem.sdk.openapi.okhttp_gson.invoker.JSON;
import io.nem.sdk.openapi.okhttp_gson.model.BlockInfoDTO;
import io.nem.sdk.openapi.okhttp_gson.model.TransactionInfoDTO;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.concurrent.CompletableFuture;
import okhttp3.OkHttpClient;
import okhttp3.Request;
import okhttp3.WebSocket;
import okhttp3.WebSocketListener;
import org.apache.commons.lang3.exception.ExceptionUtils;

public class ListenerOkHttp
extends ListenerBase
implements Listener {
    private final URL url;
    private final OkHttpClient httpClient;
    private final TransactionMapper transactionMapper;
    private WebSocket webSocket;

    public ListenerOkHttp(OkHttpClient httpClient, String url, JSON json) {
        super((JsonHelper)new JsonHelperGson(json.getGson()));
        try {
            this.url = new URL(url);
        }
        catch (MalformedURLException e) {
            throw new IllegalArgumentException("Parameter '" + url + "' is not a valid URL. " + ExceptionUtils.getMessage((Throwable)e));
        }
        this.httpClient = httpClient;
        this.transactionMapper = new GeneralTransactionMapper(this.getJsonHelper());
    }

    public CompletableFuture<Void> open() {
        final CompletableFuture<Void> future = new CompletableFuture<Void>();
        if (this.webSocket != null) {
            return CompletableFuture.completedFuture(null);
        }
        Request webSocketRequest = new Request.Builder().url(this.checkTrailingSlash(this.url.toString()) + "ws").build();
        WebSocketListener webSocketListener = new WebSocketListener(){

            public void onMessage(WebSocket webSocket, String text) {
                ListenerOkHttp.this.handle(ListenerOkHttp.this.getJsonHelper().parse(text, JsonObject.class), future);
            }
        };
        this.webSocket = this.httpClient.newWebSocket(webSocketRequest, webSocketListener);
        return future;
    }

    private String checkTrailingSlash(String url) {
        return url.endsWith("/") ? url : url + "/";
    }

    protected BlockInfo toBlockInfo(Object blockInfoDTO) {
        return BlockRepositoryOkHttpImpl.toBlockInfo((BlockInfoDTO)this.getJsonHelper().convert(blockInfoDTO, BlockInfoDTO.class));
    }

    protected Transaction toTransaction(Object transactionInfo) {
        return this.transactionMapper.map((TransactionInfoDTO)this.getJsonHelper().convert(transactionInfo, TransactionInfoDTO.class));
    }

    public void close() {
        if (this.webSocket != null) {
            this.setUid(null);
            this.webSocket.close(1000, null);
            this.webSocket = null;
        }
    }

    protected void subscribeTo(String channel) {
        ListenerSubscribeMessage subscribeMessage = new ListenerSubscribeMessage(this.getUid(), channel);
        this.webSocket.send(this.getJsonHelper().print((Object)subscribeMessage));
    }
}

