/*
 * Decompiled with CFR 0.152.
 */
package io.nem.sdk.infrastructure.okhttp;

import com.google.gson.Gson;
import io.nem.sdk.api.JsonSerialization;
import io.nem.sdk.infrastructure.okhttp.JsonHelperGson;
import io.nem.sdk.infrastructure.okhttp.mappers.GeneralTransactionMapper;
import io.nem.sdk.model.transaction.JsonHelper;
import io.nem.sdk.model.transaction.Transaction;
import io.nem.sdk.openapi.okhttp_gson.model.TransactionInfoDTO;
import org.apache.commons.lang3.Validate;

public class JsonSerializationOkHttp
implements JsonSerialization {
    private final GeneralTransactionMapper generalTransactionMapper;
    private final JsonHelper jsonHelper;

    public JsonSerializationOkHttp(Gson objectMapper) {
        Validate.notNull((Object)objectMapper, (String)"ObjectMapper must not be null", (Object[])new Object[0]);
        this.jsonHelper = new JsonHelperGson(objectMapper);
        this.generalTransactionMapper = new GeneralTransactionMapper(this.jsonHelper);
    }

    public String transactionToJson(Transaction transaction) {
        Validate.notNull((Object)transaction, (String)"Transaction must not be null", (Object[])new Object[0]);
        return this.jsonHelper.print((Object)this.generalTransactionMapper.map(transaction));
    }

    public Transaction jsonToTransaction(String json) {
        Validate.notNull((Object)json, (String)"Json must not be null", (Object[])new Object[0]);
        return this.generalTransactionMapper.map((TransactionInfoDTO)this.jsonHelper.parse(json, TransactionInfoDTO.class));
    }
}

