/*
 * Decompiled with CFR 0.152.
 */
package io.nem.sdk.infrastructure.okhttp;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonPrimitive;
import com.google.gson.JsonSerializationContext;
import com.google.gson.JsonSerializer;
import com.google.gson.internal.LinkedTreeMap;
import io.nem.sdk.infrastructure.okhttp.CollectionAdapter;
import io.nem.sdk.model.transaction.JsonHelper;
import io.nem.sdk.openapi.okhttp_gson.invoker.JSON;
import java.lang.reflect.Type;
import java.math.BigInteger;
import java.sql.Date;
import java.util.Collection;
import java.util.TreeSet;
import org.apache.commons.lang3.StringUtils;
import org.threeten.bp.LocalDate;
import org.threeten.bp.OffsetDateTime;

public class JsonHelperGson
implements JsonHelper {
    private final Gson objectMapper;
    private final Gson prettyObjectMapper;

    public JsonHelperGson() {
        this(JsonHelperGson.creatGson(false), JsonHelperGson.creatGson(true));
    }

    public JsonHelperGson(Gson objectMapper) {
        this(objectMapper, JsonHelperGson.creatGson(true));
    }

    public JsonHelperGson(Gson objectMapper, Gson prettyObjectMapper) {
        this.objectMapper = objectMapper;
        this.prettyObjectMapper = prettyObjectMapper;
    }

    public static final Gson creatGson(boolean pretty) {
        JSON json = new JSON();
        JSON.DateTypeAdapter dateTypeAdapter = new JSON.DateTypeAdapter();
        JSON.SqlDateTypeAdapter sqlDateTypeAdapter = new JSON.SqlDateTypeAdapter();
        JSON.OffsetDateTimeTypeAdapter offsetDateTimeTypeAdapter = new JSON.OffsetDateTimeTypeAdapter();
        JSON.LocalDateTypeAdapter localDateTypeAdapter = new JSON.LocalDateTypeAdapter(json);
        JSON.ByteArrayAdapter byteArrayAdapter = new JSON.ByteArrayAdapter(json);
        GsonBuilder builder = JSON.createGson().registerTypeHierarchyAdapter(Collection.class, (Object)new CollectionAdapter()).registerTypeAdapter(LinkedTreeMap.class, (Object)new SortedJsonSerializer()).registerTypeAdapter(BigInteger.class, (Object)new BigIntegerJsonSerializer()).registerTypeAdapter(Double.class, (Object)new DoubleJsonSerializer()).registerTypeAdapter(java.util.Date.class, (Object)dateTypeAdapter).registerTypeAdapter(Date.class, (Object)sqlDateTypeAdapter).registerTypeAdapter(OffsetDateTime.class, (Object)offsetDateTimeTypeAdapter).registerTypeAdapter(LocalDate.class, (Object)localDateTypeAdapter).registerTypeAdapter(byte[].class, (Object)byteArrayAdapter);
        if (pretty) {
            builder.setPrettyPrinting();
        }
        return builder.create();
    }

    public <T> T parse(String string, Class<T> clazz) {
        try {
            if (StringUtils.isEmpty((CharSequence)string)) {
                return null;
            }
            return (T)this.objectMapper.fromJson(string, clazz);
        }
        catch (Exception e) {
            throw JsonHelperGson.handleException(e);
        }
    }

    public Object parse(String string) {
        return this.parse(string, JsonObject.class);
    }

    public String print(Object object) {
        try {
            if (object == null) {
                return null;
            }
            return this.objectMapper.toJson(object);
        }
        catch (Exception e) {
            throw new IllegalArgumentException(e.getMessage(), e);
        }
    }

    public String prettyPrint(Object object) {
        try {
            if (object == null) {
                return null;
            }
            return this.prettyObjectMapper.toJson(object);
        }
        catch (Exception e) {
            throw new IllegalArgumentException(e.getMessage(), e);
        }
    }

    private static IllegalArgumentException handleException(Exception e) {
        return new IllegalArgumentException(e.getMessage(), e);
    }

    public <T> T convert(Object object, Class<T> instanceClass) {
        if (object == null) {
            return null;
        }
        if (instanceClass.isInstance(object)) {
            return (T)object;
        }
        return this.parse(this.print(object), instanceClass);
    }

    public Integer getInteger(Object object, String ... path) {
        JsonElement child = this.getNode(this.convert(object, JsonObject.class), path);
        if (child == null || child.isJsonNull()) {
            return null;
        }
        if (child.isJsonObject()) {
            throw new IllegalArgumentException("Cannot extract a Integer from an json object");
        }
        return (int)child.getAsDouble();
    }

    public String getString(Object object, String ... path) {
        JsonElement child = this.getNode(this.convert(object, JsonObject.class), path);
        if (child == null || child.isJsonNull()) {
            return null;
        }
        if (child.isJsonObject()) {
            throw new IllegalArgumentException("Cannot extract a String from an json object");
        }
        return child.getAsString();
    }

    public Long getLong(Object object, String ... path) {
        JsonElement child = this.getNode(this.convert(object, JsonObject.class), path);
        if (child == null || child.isJsonNull()) {
            return null;
        }
        if (child.isJsonObject()) {
            throw new IllegalArgumentException("Cannot extract a Long from an json object");
        }
        return (long)child.getAsDouble();
    }

    public Boolean getBoolean(Object object, String ... path) {
        JsonElement child = this.getNode(this.convert(object, JsonObject.class), path);
        if (child == null || child.isJsonNull()) {
            return null;
        }
        if (child.isJsonObject()) {
            throw new IllegalArgumentException("Cannot extract a Boolean from an json object");
        }
        return child.getAsBoolean();
    }

    public BigInteger getBigInteger(Object object, String ... path) {
        String string = this.getString(object, path);
        if (string == null) {
            return null;
        }
        return new BigInteger(string);
    }

    public boolean contains(Object object, String ... path) {
        JsonElement child = this.getNode(this.convert(object, JsonObject.class), path);
        return child != null && !child.isJsonNull();
    }

    private JsonElement getNode(JsonObject parent, String ... path) {
        JsonObject child = parent;
        if (child == null) {
            return null;
        }
        if (path.length == 0) {
            return child;
        }
        if (!child.isJsonObject()) {
            return null;
        }
        int index = 0;
        for (String attribute : path) {
            if ((child = child.get(attribute)) == null) {
                return null;
            }
            if (++index >= path.length || child.isJsonObject()) continue;
            return null;
        }
        return child;
    }

    private static class SortedJsonSerializer
    implements JsonSerializer<LinkedTreeMap> {
        private SortedJsonSerializer() {
        }

        public JsonElement serialize(LinkedTreeMap foo, Type type, JsonSerializationContext context) {
            JsonObject object = new JsonObject();
            TreeSet sorted = new TreeSet(foo.keySet());
            for (Object key : sorted) {
                object.add((String)key, context.serialize(foo.get(key)));
            }
            return object;
        }
    }

    private static class DoubleJsonSerializer
    implements JsonSerializer<Double> {
        private DoubleJsonSerializer() {
        }

        public JsonElement serialize(Double src, Type typeOfSrc, JsonSerializationContext context) {
            return new JsonPrimitive((Number)src.longValue());
        }
    }

    private static class BigIntegerJsonSerializer
    implements JsonSerializer<BigInteger> {
        private BigIntegerJsonSerializer() {
        }

        public JsonElement serialize(BigInteger src, Type typeOfSrc, JsonSerializationContext context) {
            return new JsonPrimitive(src.toString());
        }
    }
}

