/*
 * Decompiled with CFR 0.152.
 */
package io.nem.sdk.infrastructure.okhttp;

import io.nem.sdk.api.DiagnosticRepository;
import io.nem.sdk.infrastructure.okhttp.AbstractRepositoryOkHttpImpl;
import io.nem.sdk.model.blockchain.BlockchainStorageInfo;
import io.nem.sdk.model.blockchain.ServerInfo;
import io.nem.sdk.openapi.okhttp_gson.api.DiagnosticRoutesApi;
import io.nem.sdk.openapi.okhttp_gson.invoker.ApiClient;
import io.nem.sdk.openapi.okhttp_gson.model.ServerDTO;
import io.nem.sdk.openapi.okhttp_gson.model.ServerInfoDTO;
import io.nem.sdk.openapi.okhttp_gson.model.StorageInfoDTO;
import io.reactivex.Observable;
import java.util.concurrent.Callable;

public class DiagnosticRepositoryOkHttpImpl
extends AbstractRepositoryOkHttpImpl
implements DiagnosticRepository {
    private final DiagnosticRoutesApi client;

    public DiagnosticRepositoryOkHttpImpl(ApiClient apiClient) {
        super(apiClient);
        this.client = new DiagnosticRoutesApi(apiClient);
    }

    public Observable<BlockchainStorageInfo> getBlockchainStorage() {
        Callable<StorageInfoDTO> callback = () -> ((DiagnosticRoutesApi)this.getClient()).getDiagnosticStorage();
        return this.exceptionHandling(this.call(callback).map(this::toBlockchainStorageInfo));
    }

    private BlockchainStorageInfo toBlockchainStorageInfo(StorageInfoDTO blockchainStorageInfoDTO) {
        return new BlockchainStorageInfo(blockchainStorageInfoDTO.getNumAccounts(), blockchainStorageInfoDTO.getNumBlocks(), blockchainStorageInfoDTO.getNumTransactions());
    }

    public Observable<ServerInfo> getServerInfo() {
        Callable<ServerDTO> callback = () -> ((DiagnosticRoutesApi)this.getClient()).getServerInfo();
        return this.exceptionHandling(this.call(callback).map(ServerDTO::getServerInfo).map(this::toServerInfo));
    }

    private ServerInfo toServerInfo(ServerInfoDTO serverInfoDTO) {
        return new ServerInfo(serverInfoDTO.getRestVersion(), serverInfoDTO.getSdkVersion());
    }

    public DiagnosticRoutesApi getClient() {
        return this.client;
    }
}

