/*
 * Decompiled with CFR 0.152.
 */
package io.nem.sdk.infrastructure.okhttp;

import io.nem.core.utils.Suppliers;
import io.nem.sdk.api.QueryParams;
import io.nem.sdk.api.RepositoryCallException;
import io.nem.sdk.infrastructure.okhttp.JsonHelperGson;
import io.nem.sdk.infrastructure.okhttp.NetworkRepositoryOkHttpImpl;
import io.nem.sdk.model.blockchain.NetworkType;
import io.nem.sdk.model.transaction.JsonHelper;
import io.nem.sdk.openapi.okhttp_gson.invoker.ApiClient;
import io.nem.sdk.openapi.okhttp_gson.invoker.ApiException;
import io.reactivex.Observable;
import io.reactivex.functions.Function;
import java.util.ArrayList;
import java.util.Optional;
import java.util.concurrent.Callable;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.exception.ExceptionUtils;

public abstract class AbstractRepositoryOkHttpImpl {
    private final Supplier<Observable<NetworkType>> networkTypeObservable = Suppliers.memoize(() -> new NetworkRepositoryOkHttpImpl(apiClient).getNetworkType().cache());
    private final JsonHelper jsonHelper;

    public AbstractRepositoryOkHttpImpl(ApiClient apiClient) {
        this.jsonHelper = new JsonHelperGson(apiClient.getJSON().getGson());
    }

    public <T> Observable<T> call(Callable<T> callback) {
        Function resumeFunction = this::onError;
        return Observable.defer(() -> {
            try {
                return Observable.just(callback.call());
            }
            catch (Exception e) {
                return this.onError(e);
            }
        }).onErrorResumeNext(resumeFunction);
    }

    public RepositoryCallException exceptionHandling(Throwable e) {
        if (e instanceof RepositoryCallException) {
            return (RepositoryCallException)e;
        }
        return new RepositoryCallException(this.extractMessageFromException(e), e);
    }

    private String extractMessageFromException(Throwable e) {
        ArrayList<String> messages = new ArrayList<String>();
        messages.add(ExceptionUtils.getMessage((Throwable)e));
        if (e instanceof ApiException) {
            messages.add("" + ((ApiException)e).getCode());
            String responseBody = ((ApiException)e).getResponseBody();
            if (responseBody != null) {
                try {
                    Object json = this.jsonHelper.parse(responseBody);
                    messages.add(this.jsonHelper.getString(json, new String[]{"code"}));
                    messages.add(this.jsonHelper.getString(json, new String[]{"message"}));
                }
                catch (IllegalArgumentException ignore) {
                    messages.add(StringUtils.truncate((String)responseBody, (int)100));
                }
            }
        }
        return messages.stream().filter(StringUtils::isNotBlank).collect(Collectors.joining(" - "));
    }

    public <T> Observable<T> onError(Throwable e) {
        return Observable.error((Throwable)this.exceptionHandling(e));
    }

    protected NetworkType getNetworkTypeBlocking() {
        return (NetworkType)this.networkTypeObservable.get().blockingFirst();
    }

    public <T> Observable<T> exceptionHandling(Observable<T> observable) {
        Function resumeFunction = this::onError;
        return observable.onErrorResumeNext(resumeFunction);
    }

    protected Integer getPageSize(Optional<QueryParams> queryParams) {
        return queryParams.map(QueryParams::getPageSize).orElse(null);
    }

    protected String getId(Optional<QueryParams> queryParams) {
        return queryParams.map(QueryParams::getId).orElse(null);
    }

    protected String getOrder(Optional<QueryParams> queryParams) {
        return queryParams.map(QueryParams::getOrder).orElse(null);
    }

    public JsonHelper getJsonHelper() {
        return this.jsonHelper;
    }
}

