/*
 * Decompiled with CFR 0.152.
 */
package io.nem.catapult.builders;

import io.nem.catapult.builders.AmountDto;
import io.nem.catapult.builders.GeneratorUtils;
import io.nem.catapult.builders.Serializer;
import io.nem.catapult.builders.UnresolvedMosaicIdDto;
import java.io.DataInputStream;

public class UnresolvedMosaicBuilder
implements Serializer {
    private final UnresolvedMosaicIdDto mosaicId;
    private final AmountDto amount;

    protected UnresolvedMosaicBuilder(DataInputStream stream) {
        this.mosaicId = UnresolvedMosaicIdDto.loadFromBinary(stream);
        this.amount = AmountDto.loadFromBinary(stream);
    }

    protected UnresolvedMosaicBuilder(UnresolvedMosaicIdDto mosaicId, AmountDto amount) {
        GeneratorUtils.notNull(mosaicId, "mosaicId is null", new Object[0]);
        GeneratorUtils.notNull(amount, "amount is null", new Object[0]);
        this.mosaicId = mosaicId;
        this.amount = amount;
    }

    public static UnresolvedMosaicBuilder create(UnresolvedMosaicIdDto mosaicId, AmountDto amount) {
        return new UnresolvedMosaicBuilder(mosaicId, amount);
    }

    public UnresolvedMosaicIdDto getMosaicId() {
        return this.mosaicId;
    }

    public AmountDto getAmount() {
        return this.amount;
    }

    @Override
    public int getSize() {
        int size = 0;
        size += this.mosaicId.getSize();
        return size += this.amount.getSize();
    }

    public static UnresolvedMosaicBuilder loadFromBinary(DataInputStream stream) {
        return new UnresolvedMosaicBuilder(stream);
    }

    @Override
    public byte[] serialize() {
        return GeneratorUtils.serialize(dataOutputStream -> {
            byte[] mosaicIdBytes = this.mosaicId.serialize();
            dataOutputStream.write(mosaicIdBytes, 0, mosaicIdBytes.length);
            byte[] amountBytes = this.amount.serialize();
            dataOutputStream.write(amountBytes, 0, amountBytes.length);
        });
    }
}

