/*
 * Decompiled with CFR 0.152.
 */
package io.nem.catapult.builders;

import io.nem.catapult.builders.GeneratorUtils;
import io.nem.catapult.builders.Serializer;
import io.nem.catapult.builders.UnresolvedAddressDto;
import io.nem.catapult.builders.UnresolvedMosaicBuilder;
import java.io.DataInputStream;
import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.List;

public final class TransferTransactionBodyBuilder
implements Serializer {
    private final UnresolvedAddressDto recipientAddress;
    private final int transferTransactionBody_Reserved1;
    private final List<UnresolvedMosaicBuilder> mosaics;
    private final ByteBuffer message;

    protected TransferTransactionBodyBuilder(DataInputStream stream) {
        try {
            this.recipientAddress = UnresolvedAddressDto.loadFromBinary(stream);
            int mosaicsCount = stream.readByte();
            short messageSize = Short.reverseBytes(stream.readShort());
            this.transferTransactionBody_Reserved1 = Integer.reverseBytes(stream.readInt());
            this.mosaics = new ArrayList<UnresolvedMosaicBuilder>(mosaicsCount);
            for (int i = 0; i < mosaicsCount; ++i) {
                this.mosaics.add(UnresolvedMosaicBuilder.loadFromBinary(stream));
            }
            this.message = ByteBuffer.allocate(messageSize);
            stream.readFully(this.message.array());
        }
        catch (Exception e) {
            throw GeneratorUtils.getExceptionToPropagate(e);
        }
    }

    protected TransferTransactionBodyBuilder(UnresolvedAddressDto recipientAddress, List<UnresolvedMosaicBuilder> mosaics, ByteBuffer message) {
        GeneratorUtils.notNull(recipientAddress, "recipientAddress is null", new Object[0]);
        GeneratorUtils.notNull(mosaics, "mosaics is null", new Object[0]);
        GeneratorUtils.notNull(message, "message is null", new Object[0]);
        this.recipientAddress = recipientAddress;
        this.transferTransactionBody_Reserved1 = 0;
        this.mosaics = mosaics;
        this.message = message;
    }

    public static TransferTransactionBodyBuilder create(UnresolvedAddressDto recipientAddress, List<UnresolvedMosaicBuilder> mosaics, ByteBuffer message) {
        return new TransferTransactionBodyBuilder(recipientAddress, mosaics, message);
    }

    public UnresolvedAddressDto getRecipientAddress() {
        return this.recipientAddress;
    }

    private int getTransferTransactionBody_Reserved1() {
        return this.transferTransactionBody_Reserved1;
    }

    public List<UnresolvedMosaicBuilder> getMosaics() {
        return this.mosaics;
    }

    public ByteBuffer getMessage() {
        return this.message;
    }

    @Override
    public int getSize() {
        int size = 0;
        size += this.recipientAddress.getSize();
        ++size;
        size += 2;
        size += 4;
        size += this.mosaics.stream().mapToInt(o -> o.getSize()).sum();
        return size += this.message.array().length;
    }

    public static TransferTransactionBodyBuilder loadFromBinary(DataInputStream stream) {
        return new TransferTransactionBodyBuilder(stream);
    }

    @Override
    public byte[] serialize() {
        return GeneratorUtils.serialize(dataOutputStream -> {
            byte[] recipientAddressBytes = this.recipientAddress.serialize();
            dataOutputStream.write(recipientAddressBytes, 0, recipientAddressBytes.length);
            dataOutputStream.writeByte((byte)this.mosaics.size());
            dataOutputStream.writeShort(Short.reverseBytes((short)this.message.array().length));
            dataOutputStream.writeInt(Integer.reverseBytes(this.getTransferTransactionBody_Reserved1()));
            for (int i = 0; i < this.mosaics.size(); ++i) {
                byte[] mosaicsBytes = this.mosaics.get(i).serialize();
                dataOutputStream.write(mosaicsBytes, 0, mosaicsBytes.length);
            }
            dataOutputStream.write(this.message.array(), 0, this.message.array().length);
        });
    }
}

