/*
 * Decompiled with CFR 0.152.
 */
package io.nem.catapult.builders;

import io.nem.catapult.builders.GeneratorUtils;
import java.io.DataInputStream;

public enum NetworkTypeDto {
    PUBLIC(104),
    PUBLIC_TEST(-104),
    MIJIN(96),
    MIJIN_TEST(-112);

    private final byte value;

    public byte getValue() {
        return this.value;
    }

    private NetworkTypeDto(byte value) {
        this.value = value;
    }

    public static NetworkTypeDto rawValueOf(byte value) {
        for (NetworkTypeDto current : NetworkTypeDto.values()) {
            if (value != current.value) continue;
            return current;
        }
        throw new IllegalArgumentException(value + " was not a backing value for NetworkTypeDto.");
    }

    public int getSize() {
        return 1;
    }

    public static NetworkTypeDto loadFromBinary(DataInputStream stream) {
        try {
            byte streamValue = stream.readByte();
            return NetworkTypeDto.rawValueOf(streamValue);
        }
        catch (Exception e) {
            throw GeneratorUtils.getExceptionToPropagate(e);
        }
    }

    public byte[] serialize() {
        return GeneratorUtils.serialize(dataOutputStream -> dataOutputStream.writeByte(this.value));
    }
}

