/*
 * Decompiled with CFR 0.152.
 */
package io.nem.catapult.builders;

import io.nem.catapult.builders.AmountDto;
import io.nem.catapult.builders.EntityTypeDto;
import io.nem.catapult.builders.GeneratorUtils;
import io.nem.catapult.builders.KeyDto;
import io.nem.catapult.builders.MultisigAccountModificationTransactionBodyBuilder;
import io.nem.catapult.builders.NetworkTypeDto;
import io.nem.catapult.builders.Serializer;
import io.nem.catapult.builders.SignatureDto;
import io.nem.catapult.builders.TimestampDto;
import io.nem.catapult.builders.TransactionBuilder;
import java.io.DataInputStream;
import java.util.List;

public final class MultisigAccountModificationTransactionBuilder
extends TransactionBuilder
implements Serializer {
    private final MultisigAccountModificationTransactionBodyBuilder multisigAccountModificationTransactionBody;

    protected MultisigAccountModificationTransactionBuilder(DataInputStream stream) {
        super(stream);
        this.multisigAccountModificationTransactionBody = MultisigAccountModificationTransactionBodyBuilder.loadFromBinary(stream);
    }

    protected MultisigAccountModificationTransactionBuilder(SignatureDto signature, KeyDto signerPublicKey, byte version, NetworkTypeDto network, EntityTypeDto type, AmountDto fee, TimestampDto deadline, byte minRemovalDelta, byte minApprovalDelta, List<KeyDto> publicKeyAdditions, List<KeyDto> publicKeyDeletions) {
        super(signature, signerPublicKey, version, network, type, fee, deadline);
        this.multisigAccountModificationTransactionBody = MultisigAccountModificationTransactionBodyBuilder.create(minRemovalDelta, minApprovalDelta, publicKeyAdditions, publicKeyDeletions);
    }

    public static MultisigAccountModificationTransactionBuilder create(SignatureDto signature, KeyDto signerPublicKey, byte version, NetworkTypeDto network, EntityTypeDto type, AmountDto fee, TimestampDto deadline, byte minRemovalDelta, byte minApprovalDelta, List<KeyDto> publicKeyAdditions, List<KeyDto> publicKeyDeletions) {
        return new MultisigAccountModificationTransactionBuilder(signature, signerPublicKey, version, network, type, fee, deadline, minRemovalDelta, minApprovalDelta, publicKeyAdditions, publicKeyDeletions);
    }

    public byte getMinRemovalDelta() {
        return this.multisigAccountModificationTransactionBody.getMinRemovalDelta();
    }

    public byte getMinApprovalDelta() {
        return this.multisigAccountModificationTransactionBody.getMinApprovalDelta();
    }

    public List<KeyDto> getPublicKeyAdditions() {
        return this.multisigAccountModificationTransactionBody.getPublicKeyAdditions();
    }

    public List<KeyDto> getPublicKeyDeletions() {
        return this.multisigAccountModificationTransactionBody.getPublicKeyDeletions();
    }

    @Override
    public int getSize() {
        int size = super.getSize();
        return size += this.multisigAccountModificationTransactionBody.getSize();
    }

    public static MultisigAccountModificationTransactionBuilder loadFromBinary(DataInputStream stream) {
        return new MultisigAccountModificationTransactionBuilder(stream);
    }

    @Override
    public byte[] serialize() {
        return GeneratorUtils.serialize(dataOutputStream -> {
            byte[] superBytes = super.serialize();
            dataOutputStream.write(superBytes, 0, superBytes.length);
            byte[] multisigAccountModificationTransactionBodyBytes = this.multisigAccountModificationTransactionBody.serialize();
            dataOutputStream.write(multisigAccountModificationTransactionBodyBytes, 0, multisigAccountModificationTransactionBodyBytes.length);
        });
    }
}

