/*
 * Decompiled with CFR 0.152.
 */
package io.nem.catapult.builders;

import io.nem.catapult.builders.BitMaskable;
import io.nem.catapult.builders.GeneratorUtils;
import java.io.DataInputStream;

public enum MosaicFlagsDto implements BitMaskable
{
    NONE(0),
    SUPPLY_MUTABLE(1),
    TRANSFERABLE(2),
    RESTRICTABLE(4);

    private final byte value;

    private MosaicFlagsDto(byte value) {
        this.value = value;
    }

    public static MosaicFlagsDto rawValueOf(byte value) {
        for (MosaicFlagsDto current : MosaicFlagsDto.values()) {
            if (value != current.value) continue;
            return current;
        }
        throw new IllegalArgumentException(value + " was not a backing value for MosaicFlagsDto.");
    }

    public int getSize() {
        return 1;
    }

    @Override
    public long getValue() {
        return this.value;
    }

    public static MosaicFlagsDto loadFromBinary(DataInputStream stream) {
        try {
            byte streamValue = stream.readByte();
            return MosaicFlagsDto.rawValueOf(streamValue);
        }
        catch (Exception e) {
            throw GeneratorUtils.getExceptionToPropagate(e);
        }
    }

    public byte[] serialize() {
        return GeneratorUtils.serialize(dataOutputStream -> dataOutputStream.writeByte(this.value));
    }
}

