/*
 * Decompiled with CFR 0.152.
 */
package io.nem.catapult.builders;

import io.nem.catapult.builders.AmountDto;
import io.nem.catapult.builders.GeneratorUtils;
import io.nem.catapult.builders.MosaicIdDto;
import io.nem.catapult.builders.Serializer;
import java.io.DataInputStream;

public class MosaicBuilder
implements Serializer {
    private final MosaicIdDto mosaicId;
    private final AmountDto amount;

    protected MosaicBuilder(DataInputStream stream) {
        this.mosaicId = MosaicIdDto.loadFromBinary(stream);
        this.amount = AmountDto.loadFromBinary(stream);
    }

    protected MosaicBuilder(MosaicIdDto mosaicId, AmountDto amount) {
        GeneratorUtils.notNull(mosaicId, "mosaicId is null", new Object[0]);
        GeneratorUtils.notNull(amount, "amount is null", new Object[0]);
        this.mosaicId = mosaicId;
        this.amount = amount;
    }

    public static MosaicBuilder create(MosaicIdDto mosaicId, AmountDto amount) {
        return new MosaicBuilder(mosaicId, amount);
    }

    public MosaicIdDto getMosaicId() {
        return this.mosaicId;
    }

    public AmountDto getAmount() {
        return this.amount;
    }

    @Override
    public int getSize() {
        int size = 0;
        size += this.mosaicId.getSize();
        return size += this.amount.getSize();
    }

    public static MosaicBuilder loadFromBinary(DataInputStream stream) {
        return new MosaicBuilder(stream);
    }

    @Override
    public byte[] serialize() {
        return GeneratorUtils.serialize(dataOutputStream -> {
            byte[] mosaicIdBytes = this.mosaicId.serialize();
            dataOutputStream.write(mosaicIdBytes, 0, mosaicIdBytes.length);
            byte[] amountBytes = this.amount.serialize();
            dataOutputStream.write(amountBytes, 0, amountBytes.length);
        });
    }
}

