/*
 * Decompiled with CFR 0.152.
 */
package io.nem.catapult.builders;

import io.nem.catapult.builders.GeneratorUtils;
import io.nem.catapult.builders.Serializer;
import io.nem.catapult.builders.UnresolvedAddressDto;
import io.nem.catapult.builders.UnresolvedMosaicIdDto;
import java.io.DataInputStream;

public final class MosaicAddressRestrictionTransactionBodyBuilder
implements Serializer {
    private final UnresolvedMosaicIdDto mosaicId;
    private final long restrictionKey;
    private final long previousRestrictionValue;
    private final long newRestrictionValue;
    private final UnresolvedAddressDto targetAddress;

    protected MosaicAddressRestrictionTransactionBodyBuilder(DataInputStream stream) {
        try {
            this.mosaicId = UnresolvedMosaicIdDto.loadFromBinary(stream);
            this.restrictionKey = Long.reverseBytes(stream.readLong());
            this.previousRestrictionValue = Long.reverseBytes(stream.readLong());
            this.newRestrictionValue = Long.reverseBytes(stream.readLong());
            this.targetAddress = UnresolvedAddressDto.loadFromBinary(stream);
        }
        catch (Exception e) {
            throw GeneratorUtils.getExceptionToPropagate(e);
        }
    }

    protected MosaicAddressRestrictionTransactionBodyBuilder(UnresolvedMosaicIdDto mosaicId, long restrictionKey, long previousRestrictionValue, long newRestrictionValue, UnresolvedAddressDto targetAddress) {
        GeneratorUtils.notNull(mosaicId, "mosaicId is null", new Object[0]);
        GeneratorUtils.notNull(targetAddress, "targetAddress is null", new Object[0]);
        this.mosaicId = mosaicId;
        this.restrictionKey = restrictionKey;
        this.previousRestrictionValue = previousRestrictionValue;
        this.newRestrictionValue = newRestrictionValue;
        this.targetAddress = targetAddress;
    }

    public static MosaicAddressRestrictionTransactionBodyBuilder create(UnresolvedMosaicIdDto mosaicId, long restrictionKey, long previousRestrictionValue, long newRestrictionValue, UnresolvedAddressDto targetAddress) {
        return new MosaicAddressRestrictionTransactionBodyBuilder(mosaicId, restrictionKey, previousRestrictionValue, newRestrictionValue, targetAddress);
    }

    public UnresolvedMosaicIdDto getMosaicId() {
        return this.mosaicId;
    }

    public long getRestrictionKey() {
        return this.restrictionKey;
    }

    public long getPreviousRestrictionValue() {
        return this.previousRestrictionValue;
    }

    public long getNewRestrictionValue() {
        return this.newRestrictionValue;
    }

    public UnresolvedAddressDto getTargetAddress() {
        return this.targetAddress;
    }

    @Override
    public int getSize() {
        int size = 0;
        size += this.mosaicId.getSize();
        size += 8;
        size += 8;
        size += 8;
        return size += this.targetAddress.getSize();
    }

    public static MosaicAddressRestrictionTransactionBodyBuilder loadFromBinary(DataInputStream stream) {
        return new MosaicAddressRestrictionTransactionBodyBuilder(stream);
    }

    @Override
    public byte[] serialize() {
        return GeneratorUtils.serialize(dataOutputStream -> {
            byte[] mosaicIdBytes = this.mosaicId.serialize();
            dataOutputStream.write(mosaicIdBytes, 0, mosaicIdBytes.length);
            dataOutputStream.writeLong(Long.reverseBytes(this.getRestrictionKey()));
            dataOutputStream.writeLong(Long.reverseBytes(this.getPreviousRestrictionValue()));
            dataOutputStream.writeLong(Long.reverseBytes(this.getNewRestrictionValue()));
            byte[] targetAddressBytes = this.targetAddress.serialize();
            dataOutputStream.write(targetAddressBytes, 0, targetAddressBytes.length);
        });
    }
}

