/*
 * Decompiled with CFR 0.152.
 */
package io.nem.catapult.builders;

import io.nem.catapult.builders.GeneratorUtils;
import io.nem.catapult.builders.Serializer;
import java.io.DataInputStream;
import java.nio.ByteBuffer;

public final class KeyDto
implements Serializer {
    private final ByteBuffer key;

    public KeyDto(ByteBuffer key) {
        GeneratorUtils.notNull(key, "key is null", new Object[0]);
        GeneratorUtils.isTrue(key.array().length == 32, "key should be 32 bytes", new Object[0]);
        this.key = key;
    }

    public KeyDto(DataInputStream stream) {
        try {
            this.key = ByteBuffer.allocate(32);
            stream.readFully(this.key.array());
        }
        catch (Exception e) {
            throw GeneratorUtils.getExceptionToPropagate(e);
        }
    }

    public ByteBuffer getKey() {
        return this.key;
    }

    @Override
    public int getSize() {
        return 32;
    }

    public static KeyDto loadFromBinary(DataInputStream stream) {
        return new KeyDto(stream);
    }

    @Override
    public byte[] serialize() {
        return GeneratorUtils.serialize(dataOutputStream -> dataOutputStream.write(this.key.array(), 0, this.key.array().length));
    }
}

