/*
 * Decompiled with CFR 0.152.
 */
package io.nem.catapult.builders;

import io.nem.catapult.builders.AmountDto;
import io.nem.catapult.builders.BlockDurationDto;
import io.nem.catapult.builders.EntityTypeDto;
import io.nem.catapult.builders.GeneratorUtils;
import io.nem.catapult.builders.Hash256Dto;
import io.nem.catapult.builders.HashLockTransactionBodyBuilder;
import io.nem.catapult.builders.KeyDto;
import io.nem.catapult.builders.NetworkTypeDto;
import io.nem.catapult.builders.Serializer;
import io.nem.catapult.builders.SignatureDto;
import io.nem.catapult.builders.TimestampDto;
import io.nem.catapult.builders.TransactionBuilder;
import io.nem.catapult.builders.UnresolvedMosaicBuilder;
import java.io.DataInputStream;

public final class HashLockTransactionBuilder
extends TransactionBuilder
implements Serializer {
    private final HashLockTransactionBodyBuilder hashLockTransactionBody;

    protected HashLockTransactionBuilder(DataInputStream stream) {
        super(stream);
        this.hashLockTransactionBody = HashLockTransactionBodyBuilder.loadFromBinary(stream);
    }

    protected HashLockTransactionBuilder(SignatureDto signature, KeyDto signerPublicKey, byte version, NetworkTypeDto network, EntityTypeDto type, AmountDto fee, TimestampDto deadline, UnresolvedMosaicBuilder mosaic, BlockDurationDto duration, Hash256Dto hash) {
        super(signature, signerPublicKey, version, network, type, fee, deadline);
        this.hashLockTransactionBody = HashLockTransactionBodyBuilder.create(mosaic, duration, hash);
    }

    public static HashLockTransactionBuilder create(SignatureDto signature, KeyDto signerPublicKey, byte version, NetworkTypeDto network, EntityTypeDto type, AmountDto fee, TimestampDto deadline, UnresolvedMosaicBuilder mosaic, BlockDurationDto duration, Hash256Dto hash) {
        return new HashLockTransactionBuilder(signature, signerPublicKey, version, network, type, fee, deadline, mosaic, duration, hash);
    }

    public UnresolvedMosaicBuilder getMosaic() {
        return this.hashLockTransactionBody.getMosaic();
    }

    public BlockDurationDto getDuration() {
        return this.hashLockTransactionBody.getDuration();
    }

    public Hash256Dto getHash() {
        return this.hashLockTransactionBody.getHash();
    }

    @Override
    public int getSize() {
        int size = super.getSize();
        return size += this.hashLockTransactionBody.getSize();
    }

    public static HashLockTransactionBuilder loadFromBinary(DataInputStream stream) {
        return new HashLockTransactionBuilder(stream);
    }

    @Override
    public byte[] serialize() {
        return GeneratorUtils.serialize(dataOutputStream -> {
            byte[] superBytes = super.serialize();
            dataOutputStream.write(superBytes, 0, superBytes.length);
            byte[] hashLockTransactionBodyBytes = this.hashLockTransactionBody.serialize();
            dataOutputStream.write(hashLockTransactionBodyBytes, 0, hashLockTransactionBodyBytes.length);
        });
    }
}

