/*
 * Decompiled with CFR 0.152.
 */
package io.nem.catapult.builders;

import io.nem.catapult.builders.BlockDurationDto;
import io.nem.catapult.builders.GeneratorUtils;
import io.nem.catapult.builders.Hash256Dto;
import io.nem.catapult.builders.Serializer;
import io.nem.catapult.builders.UnresolvedMosaicBuilder;
import java.io.DataInputStream;

public final class HashLockTransactionBodyBuilder
implements Serializer {
    private final UnresolvedMosaicBuilder mosaic;
    private final BlockDurationDto duration;
    private final Hash256Dto hash;

    protected HashLockTransactionBodyBuilder(DataInputStream stream) {
        this.mosaic = UnresolvedMosaicBuilder.loadFromBinary(stream);
        this.duration = BlockDurationDto.loadFromBinary(stream);
        this.hash = Hash256Dto.loadFromBinary(stream);
    }

    protected HashLockTransactionBodyBuilder(UnresolvedMosaicBuilder mosaic, BlockDurationDto duration, Hash256Dto hash) {
        GeneratorUtils.notNull(mosaic, "mosaic is null", new Object[0]);
        GeneratorUtils.notNull(duration, "duration is null", new Object[0]);
        GeneratorUtils.notNull(hash, "hash is null", new Object[0]);
        this.mosaic = mosaic;
        this.duration = duration;
        this.hash = hash;
    }

    public static HashLockTransactionBodyBuilder create(UnresolvedMosaicBuilder mosaic, BlockDurationDto duration, Hash256Dto hash) {
        return new HashLockTransactionBodyBuilder(mosaic, duration, hash);
    }

    public UnresolvedMosaicBuilder getMosaic() {
        return this.mosaic;
    }

    public BlockDurationDto getDuration() {
        return this.duration;
    }

    public Hash256Dto getHash() {
        return this.hash;
    }

    @Override
    public int getSize() {
        int size = 0;
        size += this.mosaic.getSize();
        size += this.duration.getSize();
        return size += this.hash.getSize();
    }

    public static HashLockTransactionBodyBuilder loadFromBinary(DataInputStream stream) {
        return new HashLockTransactionBodyBuilder(stream);
    }

    @Override
    public byte[] serialize() {
        return GeneratorUtils.serialize(dataOutputStream -> {
            byte[] mosaicBytes = this.mosaic.serialize();
            dataOutputStream.write(mosaicBytes, 0, mosaicBytes.length);
            byte[] durationBytes = this.duration.serialize();
            dataOutputStream.write(durationBytes, 0, durationBytes.length);
            byte[] hashBytes = this.hash.serialize();
            dataOutputStream.write(hashBytes, 0, hashBytes.length);
        });
    }
}

