/*
 * Decompiled with CFR 0.152.
 */
package io.nem.catapult.builders;

import io.nem.catapult.builders.BitMaskable;
import java.io.ByteArrayOutputStream;
import java.io.DataOutputStream;
import java.util.EnumSet;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutionException;
import java.util.function.Function;

public final class GeneratorUtils {
    private GeneratorUtils() {
    }

    public static <T> void notNull(T object, String message, Object ... values) {
        if (object == null) {
            throw new NullPointerException(String.format(message, values));
        }
    }

    public static void isTrue(boolean expression, String message, Object ... values) {
        if (!expression) {
            throw new IllegalArgumentException(String.format(message, values));
        }
    }

    public static void isFalse(boolean expression, String message, Object ... values) {
        GeneratorUtils.isTrue(!expression, message, values);
    }

    public static <T extends Enum<T>> long toLong(Class<T> enumClass, EnumSet<T> enumSet) {
        Enum[] enumValues = (Enum[])enumClass.getEnumConstants();
        GeneratorUtils.isFalse(enumValues.length > 64, "The number of enum constants is greater than 64", new Object[0]);
        long result = 0L;
        for (Enum value : enumValues) {
            if (!enumSet.contains(value)) continue;
            result += ((BitMaskable)((Object)value)).getValue();
        }
        return result;
    }

    public static <T extends Enum<T>> EnumSet<T> toSet(Class<T> enumClass, long bitMaskValue) {
        EnumSet<T> results = EnumSet.noneOf(enumClass);
        for (Enum constant : (Enum[])enumClass.getEnumConstants()) {
            if (0L == (((BitMaskable)((Object)constant)).getValue() & bitMaskValue)) continue;
            results.add(constant);
        }
        return results;
    }

    public static <E extends RuntimeException> RuntimeException getExceptionToPropagate(Exception exception, Function<Exception, E> wrap) {
        if (exception instanceof ExecutionException && RuntimeException.class.isAssignableFrom(exception.getCause().getClass())) {
            return (RuntimeException)exception.getCause();
        }
        if (exception instanceof RuntimeException) {
            return (RuntimeException)exception;
        }
        if (exception instanceof InterruptedException) {
            Thread.currentThread().interrupt();
            return new IllegalStateException(exception);
        }
        return (RuntimeException)wrap.apply(exception);
    }

    public static <E extends RuntimeException> RuntimeException getExceptionToPropagate(Exception exception) {
        return GeneratorUtils.getExceptionToPropagate(exception, RuntimeException::new);
    }

    public static <T, E extends RuntimeException> T propagate(Callable<T> callable, Function<Exception, E> wrap) {
        try {
            return callable.call();
        }
        catch (Exception e) {
            throw GeneratorUtils.getExceptionToPropagate(e, wrap);
        }
    }

    public static <T> T propagate(Callable<T> callable) {
        return GeneratorUtils.propagate(callable, RuntimeException::new);
    }

    public static byte[] serialize(ThrowingConsumer<DataOutputStream, Exception> consumer) {
        return GeneratorUtils.propagate(() -> {
            try (ByteArrayOutputStream byteArrayStream = new ByteArrayOutputStream();){
                byte[] byArray;
                try (DataOutputStream dataOutputStream = new DataOutputStream(byteArrayStream);){
                    consumer.accept(dataOutputStream);
                    byArray = byteArrayStream.toByteArray();
                }
                return byArray;
            }
        });
    }

    public static interface ThrowingConsumer<T, E extends Exception> {
        public void accept(T var1) throws E;
    }
}

