/*
 * Decompiled with CFR 0.152.
 */
package io.nem.catapult.builders;

import io.nem.catapult.builders.GeneratorUtils;
import java.io.DataInput;

public enum EntityTypeDto {
    RESERVED(0),
    ACCOUNT_ADDRESS_RESTRICTION_TRANSACTION(16720),
    ACCOUNT_MOSAIC_RESTRICTION_TRANSACTION(16976),
    ACCOUNT_OPERATION_RESTRICTION_TRANSACTION(17232),
    ACCOUNT_LINK_TRANSACTION(16716),
    ACCOUNT_METADATA_TRANSACTION(16708),
    MOSAIC_METADATA_TRANSACTION(16964),
    NAMESPACE_METADATA_TRANSACTION(17220),
    ADDRESS_ALIAS_TRANSACTION(16974),
    AGGREGATE_BONDED_TRANSACTION(16961),
    AGGREGATE_COMPLETE_TRANSACTION(16705),
    HASH_LOCK_TRANSACTION(16712),
    MODIFY_MULTISIG_ACCOUNT_TRANSACTION(16725),
    MOSAIC_DEFINITION_TRANSACTION(16717),
    MOSAIC_SUPPLY_CHANGE_TRANSACTION(16973),
    MOSAIC_ALIAS_TRANSACTION(17230),
    REGISTER_NAMESPACE_TRANSACTION(16718),
    SECRET_LOCK_TRANSACTION(16722),
    SECRET_PROOF_TRANSACTION(16978),
    TRANSFER_TRANSACTION(16724),
    MOSAIC_ADDRESS_RESTRICTION(16977),
    MOSAIC_GLOBAL_RESTRICTION(16721);

    private final short value;

    private EntityTypeDto(short value) {
        this.value = value;
    }

    public static EntityTypeDto rawValueOf(short value) {
        for (EntityTypeDto current : EntityTypeDto.values()) {
            if (value != current.value) continue;
            return current;
        }
        throw new IllegalArgumentException(value + " was not a backing value for EntityTypeDto.");
    }

    public static EntityTypeDto loadFromBinary(DataInput stream) {
        try {
            short streamValue = Short.reverseBytes(stream.readShort());
            return EntityTypeDto.rawValueOf(streamValue);
        }
        catch (Exception e) {
            throw GeneratorUtils.getExceptionToPropagate(e);
        }
    }

    public int getSize() {
        return 2;
    }

    public byte[] serialize() {
        return GeneratorUtils.serialize(dataOutputStream -> dataOutputStream.writeShort(Short.reverseBytes(this.value)));
    }

    public short getValue() {
        return this.value;
    }
}

