/*
 * Decompiled with CFR 0.152.
 */
package io.nem.catapult.builders;

import io.nem.catapult.builders.BlockDurationDto;
import io.nem.catapult.builders.EmbeddedTransactionBuilder;
import io.nem.catapult.builders.EntityTypeDto;
import io.nem.catapult.builders.GeneratorUtils;
import io.nem.catapult.builders.Hash256Dto;
import io.nem.catapult.builders.KeyDto;
import io.nem.catapult.builders.LockHashAlgorithmDto;
import io.nem.catapult.builders.NetworkTypeDto;
import io.nem.catapult.builders.SecretLockTransactionBodyBuilder;
import io.nem.catapult.builders.Serializer;
import io.nem.catapult.builders.UnresolvedAddressDto;
import io.nem.catapult.builders.UnresolvedMosaicBuilder;
import java.io.DataInputStream;

public final class EmbeddedSecretLockTransactionBuilder
extends EmbeddedTransactionBuilder
implements Serializer {
    private final SecretLockTransactionBodyBuilder secretLockTransactionBody;

    protected EmbeddedSecretLockTransactionBuilder(DataInputStream stream) {
        super(stream);
        this.secretLockTransactionBody = SecretLockTransactionBodyBuilder.loadFromBinary(stream);
    }

    protected EmbeddedSecretLockTransactionBuilder(KeyDto signerPublicKey, byte version, NetworkTypeDto network, EntityTypeDto type, Hash256Dto secret, UnresolvedMosaicBuilder mosaic, BlockDurationDto duration, LockHashAlgorithmDto hashAlgorithm, UnresolvedAddressDto recipientAddress) {
        super(signerPublicKey, version, network, type);
        this.secretLockTransactionBody = SecretLockTransactionBodyBuilder.create(secret, mosaic, duration, hashAlgorithm, recipientAddress);
    }

    public static EmbeddedSecretLockTransactionBuilder create(KeyDto signerPublicKey, byte version, NetworkTypeDto network, EntityTypeDto type, Hash256Dto secret, UnresolvedMosaicBuilder mosaic, BlockDurationDto duration, LockHashAlgorithmDto hashAlgorithm, UnresolvedAddressDto recipientAddress) {
        return new EmbeddedSecretLockTransactionBuilder(signerPublicKey, version, network, type, secret, mosaic, duration, hashAlgorithm, recipientAddress);
    }

    public Hash256Dto getSecret() {
        return this.secretLockTransactionBody.getSecret();
    }

    public UnresolvedMosaicBuilder getMosaic() {
        return this.secretLockTransactionBody.getMosaic();
    }

    public BlockDurationDto getDuration() {
        return this.secretLockTransactionBody.getDuration();
    }

    public LockHashAlgorithmDto getHashAlgorithm() {
        return this.secretLockTransactionBody.getHashAlgorithm();
    }

    public UnresolvedAddressDto getRecipientAddress() {
        return this.secretLockTransactionBody.getRecipientAddress();
    }

    @Override
    public int getSize() {
        int size = super.getSize();
        return size += this.secretLockTransactionBody.getSize();
    }

    public static EmbeddedSecretLockTransactionBuilder loadFromBinary(DataInputStream stream) {
        return new EmbeddedSecretLockTransactionBuilder(stream);
    }

    @Override
    public byte[] serialize() {
        return GeneratorUtils.serialize(dataOutputStream -> {
            byte[] superBytes = super.serialize();
            dataOutputStream.write(superBytes, 0, superBytes.length);
            byte[] secretLockTransactionBodyBytes = this.secretLockTransactionBody.serialize();
            dataOutputStream.write(secretLockTransactionBodyBytes, 0, secretLockTransactionBodyBytes.length);
        });
    }
}

