/*
 * Decompiled with CFR 0.152.
 */
package io.nem.catapult.builders;

import io.nem.catapult.builders.EmbeddedTransactionBuilder;
import io.nem.catapult.builders.EntityTypeDto;
import io.nem.catapult.builders.GeneratorUtils;
import io.nem.catapult.builders.KeyDto;
import io.nem.catapult.builders.MosaicMetadataTransactionBodyBuilder;
import io.nem.catapult.builders.NetworkTypeDto;
import io.nem.catapult.builders.Serializer;
import io.nem.catapult.builders.UnresolvedMosaicIdDto;
import java.io.DataInputStream;
import java.nio.ByteBuffer;

public final class EmbeddedMosaicMetadataTransactionBuilder
extends EmbeddedTransactionBuilder
implements Serializer {
    private final MosaicMetadataTransactionBodyBuilder mosaicMetadataTransactionBody;

    protected EmbeddedMosaicMetadataTransactionBuilder(DataInputStream stream) {
        super(stream);
        this.mosaicMetadataTransactionBody = MosaicMetadataTransactionBodyBuilder.loadFromBinary(stream);
    }

    protected EmbeddedMosaicMetadataTransactionBuilder(KeyDto signerPublicKey, byte version, NetworkTypeDto network, EntityTypeDto type, KeyDto targetPublicKey, long scopedMetadataKey, UnresolvedMosaicIdDto targetMosaicId, short valueSizeDelta, ByteBuffer value) {
        super(signerPublicKey, version, network, type);
        this.mosaicMetadataTransactionBody = MosaicMetadataTransactionBodyBuilder.create(targetPublicKey, scopedMetadataKey, targetMosaicId, valueSizeDelta, value);
    }

    public static EmbeddedMosaicMetadataTransactionBuilder create(KeyDto signerPublicKey, byte version, NetworkTypeDto network, EntityTypeDto type, KeyDto targetPublicKey, long scopedMetadataKey, UnresolvedMosaicIdDto targetMosaicId, short valueSizeDelta, ByteBuffer value) {
        return new EmbeddedMosaicMetadataTransactionBuilder(signerPublicKey, version, network, type, targetPublicKey, scopedMetadataKey, targetMosaicId, valueSizeDelta, value);
    }

    public KeyDto getTargetPublicKey() {
        return this.mosaicMetadataTransactionBody.getTargetPublicKey();
    }

    public long getScopedMetadataKey() {
        return this.mosaicMetadataTransactionBody.getScopedMetadataKey();
    }

    public UnresolvedMosaicIdDto getTargetMosaicId() {
        return this.mosaicMetadataTransactionBody.getTargetMosaicId();
    }

    public short getValueSizeDelta() {
        return this.mosaicMetadataTransactionBody.getValueSizeDelta();
    }

    public ByteBuffer getValue() {
        return this.mosaicMetadataTransactionBody.getValue();
    }

    @Override
    public int getSize() {
        int size = super.getSize();
        return size += this.mosaicMetadataTransactionBody.getSize();
    }

    public static EmbeddedMosaicMetadataTransactionBuilder loadFromBinary(DataInputStream stream) {
        return new EmbeddedMosaicMetadataTransactionBuilder(stream);
    }

    @Override
    public byte[] serialize() {
        return GeneratorUtils.serialize(dataOutputStream -> {
            byte[] superBytes = super.serialize();
            dataOutputStream.write(superBytes, 0, superBytes.length);
            byte[] mosaicMetadataTransactionBodyBytes = this.mosaicMetadataTransactionBody.serialize();
            dataOutputStream.write(mosaicMetadataTransactionBodyBytes, 0, mosaicMetadataTransactionBodyBytes.length);
        });
    }
}

