/*
 * Decompiled with CFR 0.152.
 */
package io.nem.catapult.builders;

import io.nem.catapult.builders.BlockDurationDto;
import io.nem.catapult.builders.EmbeddedTransactionBuilder;
import io.nem.catapult.builders.EntityTypeDto;
import io.nem.catapult.builders.GeneratorUtils;
import io.nem.catapult.builders.Hash256Dto;
import io.nem.catapult.builders.HashLockTransactionBodyBuilder;
import io.nem.catapult.builders.KeyDto;
import io.nem.catapult.builders.NetworkTypeDto;
import io.nem.catapult.builders.Serializer;
import io.nem.catapult.builders.UnresolvedMosaicBuilder;
import java.io.DataInputStream;

public final class EmbeddedHashLockTransactionBuilder
extends EmbeddedTransactionBuilder
implements Serializer {
    private final HashLockTransactionBodyBuilder hashLockTransactionBody;

    protected EmbeddedHashLockTransactionBuilder(DataInputStream stream) {
        super(stream);
        this.hashLockTransactionBody = HashLockTransactionBodyBuilder.loadFromBinary(stream);
    }

    protected EmbeddedHashLockTransactionBuilder(KeyDto signerPublicKey, byte version, NetworkTypeDto network, EntityTypeDto type, UnresolvedMosaicBuilder mosaic, BlockDurationDto duration, Hash256Dto hash) {
        super(signerPublicKey, version, network, type);
        this.hashLockTransactionBody = HashLockTransactionBodyBuilder.create(mosaic, duration, hash);
    }

    public static EmbeddedHashLockTransactionBuilder create(KeyDto signerPublicKey, byte version, NetworkTypeDto network, EntityTypeDto type, UnresolvedMosaicBuilder mosaic, BlockDurationDto duration, Hash256Dto hash) {
        return new EmbeddedHashLockTransactionBuilder(signerPublicKey, version, network, type, mosaic, duration, hash);
    }

    public UnresolvedMosaicBuilder getMosaic() {
        return this.hashLockTransactionBody.getMosaic();
    }

    public BlockDurationDto getDuration() {
        return this.hashLockTransactionBody.getDuration();
    }

    public Hash256Dto getHash() {
        return this.hashLockTransactionBody.getHash();
    }

    @Override
    public int getSize() {
        int size = super.getSize();
        return size += this.hashLockTransactionBody.getSize();
    }

    public static EmbeddedHashLockTransactionBuilder loadFromBinary(DataInputStream stream) {
        return new EmbeddedHashLockTransactionBuilder(stream);
    }

    @Override
    public byte[] serialize() {
        return GeneratorUtils.serialize(dataOutputStream -> {
            byte[] superBytes = super.serialize();
            dataOutputStream.write(superBytes, 0, superBytes.length);
            byte[] hashLockTransactionBodyBytes = this.hashLockTransactionBody.serialize();
            dataOutputStream.write(hashLockTransactionBodyBytes, 0, hashLockTransactionBodyBytes.length);
        });
    }
}

