/*
 * Decompiled with CFR 0.152.
 */
package io.nem.catapult.builders;

import io.nem.catapult.builders.AddressAliasTransactionBodyBuilder;
import io.nem.catapult.builders.AddressDto;
import io.nem.catapult.builders.AliasActionDto;
import io.nem.catapult.builders.EmbeddedTransactionBuilder;
import io.nem.catapult.builders.EntityTypeDto;
import io.nem.catapult.builders.GeneratorUtils;
import io.nem.catapult.builders.KeyDto;
import io.nem.catapult.builders.NamespaceIdDto;
import io.nem.catapult.builders.NetworkTypeDto;
import io.nem.catapult.builders.Serializer;
import java.io.DataInputStream;

public final class EmbeddedAddressAliasTransactionBuilder
extends EmbeddedTransactionBuilder
implements Serializer {
    private final AddressAliasTransactionBodyBuilder addressAliasTransactionBody;

    protected EmbeddedAddressAliasTransactionBuilder(DataInputStream stream) {
        super(stream);
        this.addressAliasTransactionBody = AddressAliasTransactionBodyBuilder.loadFromBinary(stream);
    }

    protected EmbeddedAddressAliasTransactionBuilder(KeyDto signerPublicKey, byte version, NetworkTypeDto network, EntityTypeDto type, NamespaceIdDto namespaceId, AddressDto address, AliasActionDto aliasAction) {
        super(signerPublicKey, version, network, type);
        this.addressAliasTransactionBody = AddressAliasTransactionBodyBuilder.create(namespaceId, address, aliasAction);
    }

    public static EmbeddedAddressAliasTransactionBuilder create(KeyDto signerPublicKey, byte version, NetworkTypeDto network, EntityTypeDto type, NamespaceIdDto namespaceId, AddressDto address, AliasActionDto aliasAction) {
        return new EmbeddedAddressAliasTransactionBuilder(signerPublicKey, version, network, type, namespaceId, address, aliasAction);
    }

    public NamespaceIdDto getNamespaceId() {
        return this.addressAliasTransactionBody.getNamespaceId();
    }

    public AddressDto getAddress() {
        return this.addressAliasTransactionBody.getAddress();
    }

    public AliasActionDto getAliasAction() {
        return this.addressAliasTransactionBody.getAliasAction();
    }

    @Override
    public int getSize() {
        int size = super.getSize();
        return size += this.addressAliasTransactionBody.getSize();
    }

    public static EmbeddedAddressAliasTransactionBuilder loadFromBinary(DataInputStream stream) {
        return new EmbeddedAddressAliasTransactionBuilder(stream);
    }

    @Override
    public byte[] serialize() {
        return GeneratorUtils.serialize(dataOutputStream -> {
            byte[] superBytes = super.serialize();
            dataOutputStream.write(superBytes, 0, superBytes.length);
            byte[] addressAliasTransactionBodyBytes = this.addressAliasTransactionBody.serialize();
            dataOutputStream.write(addressAliasTransactionBodyBytes, 0, addressAliasTransactionBodyBytes.length);
        });
    }
}

