/*
 * Decompiled with CFR 0.152.
 */
package io.nem.catapult.builders;

import io.nem.catapult.builders.AccountMetadataTransactionBodyBuilder;
import io.nem.catapult.builders.EmbeddedTransactionBuilder;
import io.nem.catapult.builders.EntityTypeDto;
import io.nem.catapult.builders.GeneratorUtils;
import io.nem.catapult.builders.KeyDto;
import io.nem.catapult.builders.NetworkTypeDto;
import io.nem.catapult.builders.Serializer;
import java.io.DataInputStream;
import java.nio.ByteBuffer;

public final class EmbeddedAccountMetadataTransactionBuilder
extends EmbeddedTransactionBuilder
implements Serializer {
    private final AccountMetadataTransactionBodyBuilder accountMetadataTransactionBody;

    protected EmbeddedAccountMetadataTransactionBuilder(DataInputStream stream) {
        super(stream);
        this.accountMetadataTransactionBody = AccountMetadataTransactionBodyBuilder.loadFromBinary(stream);
    }

    protected EmbeddedAccountMetadataTransactionBuilder(KeyDto signerPublicKey, byte version, NetworkTypeDto network, EntityTypeDto type, KeyDto targetPublicKey, long scopedMetadataKey, short valueSizeDelta, ByteBuffer value) {
        super(signerPublicKey, version, network, type);
        this.accountMetadataTransactionBody = AccountMetadataTransactionBodyBuilder.create(targetPublicKey, scopedMetadataKey, valueSizeDelta, value);
    }

    public static EmbeddedAccountMetadataTransactionBuilder create(KeyDto signerPublicKey, byte version, NetworkTypeDto network, EntityTypeDto type, KeyDto targetPublicKey, long scopedMetadataKey, short valueSizeDelta, ByteBuffer value) {
        return new EmbeddedAccountMetadataTransactionBuilder(signerPublicKey, version, network, type, targetPublicKey, scopedMetadataKey, valueSizeDelta, value);
    }

    public KeyDto getTargetPublicKey() {
        return this.accountMetadataTransactionBody.getTargetPublicKey();
    }

    public long getScopedMetadataKey() {
        return this.accountMetadataTransactionBody.getScopedMetadataKey();
    }

    public short getValueSizeDelta() {
        return this.accountMetadataTransactionBody.getValueSizeDelta();
    }

    public ByteBuffer getValue() {
        return this.accountMetadataTransactionBody.getValue();
    }

    @Override
    public int getSize() {
        int size = super.getSize();
        return size += this.accountMetadataTransactionBody.getSize();
    }

    public static EmbeddedAccountMetadataTransactionBuilder loadFromBinary(DataInputStream stream) {
        return new EmbeddedAccountMetadataTransactionBuilder(stream);
    }

    @Override
    public byte[] serialize() {
        return GeneratorUtils.serialize(dataOutputStream -> {
            byte[] superBytes = super.serialize();
            dataOutputStream.write(superBytes, 0, superBytes.length);
            byte[] accountMetadataTransactionBodyBytes = this.accountMetadataTransactionBody.serialize();
            dataOutputStream.write(accountMetadataTransactionBodyBytes, 0, accountMetadataTransactionBodyBytes.length);
        });
    }
}

