/*
 * Decompiled with CFR 0.152.
 */
package io.nem.catapult.builders;

import io.nem.catapult.builders.CosignatureBuilder;
import io.nem.catapult.builders.GeneratorUtils;
import io.nem.catapult.builders.Hash256Dto;
import io.nem.catapult.builders.KeyDto;
import io.nem.catapult.builders.Serializer;
import io.nem.catapult.builders.SignatureDto;
import java.io.DataInputStream;

public final class DetachedCosignatureBuilder
extends CosignatureBuilder
implements Serializer {
    private final Hash256Dto parentHash;

    protected DetachedCosignatureBuilder(DataInputStream stream) {
        super(stream);
        this.parentHash = Hash256Dto.loadFromBinary(stream);
    }

    protected DetachedCosignatureBuilder(KeyDto signerPublicKey, SignatureDto signature, Hash256Dto parentHash) {
        super(signerPublicKey, signature);
        GeneratorUtils.notNull(parentHash, "parentHash is null", new Object[0]);
        this.parentHash = parentHash;
    }

    public static DetachedCosignatureBuilder create(KeyDto signerPublicKey, SignatureDto signature, Hash256Dto parentHash) {
        return new DetachedCosignatureBuilder(signerPublicKey, signature, parentHash);
    }

    public Hash256Dto getParentHash() {
        return this.parentHash;
    }

    @Override
    public int getSize() {
        int size = super.getSize();
        return size += this.parentHash.getSize();
    }

    public static DetachedCosignatureBuilder loadFromBinary(DataInputStream stream) {
        return new DetachedCosignatureBuilder(stream);
    }

    @Override
    public byte[] serialize() {
        return GeneratorUtils.serialize(dataOutputStream -> {
            byte[] superBytes = super.serialize();
            dataOutputStream.write(superBytes, 0, superBytes.length);
            byte[] parentHashBytes = this.parentHash.serialize();
            dataOutputStream.write(parentHashBytes, 0, parentHashBytes.length);
        });
    }
}

