/*
 * Decompiled with CFR 0.152.
 */
package io.nem.catapult.builders;

import io.nem.catapult.builders.GeneratorUtils;
import io.nem.catapult.builders.Serializer;
import java.io.DataInputStream;

public final class BlockFeeMultiplierDto
implements Serializer {
    private final int blockFeeMultiplier;

    public BlockFeeMultiplierDto(int blockFeeMultiplier) {
        this.blockFeeMultiplier = blockFeeMultiplier;
    }

    public BlockFeeMultiplierDto(DataInputStream stream) {
        try {
            this.blockFeeMultiplier = Integer.reverseBytes(stream.readInt());
        }
        catch (Exception e) {
            throw GeneratorUtils.getExceptionToPropagate(e);
        }
    }

    public int getBlockFeeMultiplier() {
        return this.blockFeeMultiplier;
    }

    @Override
    public int getSize() {
        return 4;
    }

    public static BlockFeeMultiplierDto loadFromBinary(DataInputStream stream) {
        return new BlockFeeMultiplierDto(stream);
    }

    @Override
    public byte[] serialize() {
        return GeneratorUtils.serialize(dataOutputStream -> dataOutputStream.writeInt(Integer.reverseBytes(this.getBlockFeeMultiplier())));
    }
}

