/*
 * Decompiled with CFR 0.152.
 */
package io.nem.catapult.builders;

import io.nem.catapult.builders.AggregateTransactionBodyBuilder;
import io.nem.catapult.builders.AmountDto;
import io.nem.catapult.builders.CosignatureBuilder;
import io.nem.catapult.builders.EmbeddedTransactionBuilder;
import io.nem.catapult.builders.EntityTypeDto;
import io.nem.catapult.builders.GeneratorUtils;
import io.nem.catapult.builders.Hash256Dto;
import io.nem.catapult.builders.KeyDto;
import io.nem.catapult.builders.NetworkTypeDto;
import io.nem.catapult.builders.Serializer;
import io.nem.catapult.builders.SignatureDto;
import io.nem.catapult.builders.TimestampDto;
import io.nem.catapult.builders.TransactionBuilder;
import java.io.DataInputStream;
import java.util.List;

public final class AggregateCompleteTransactionBuilder
extends TransactionBuilder
implements Serializer {
    private final AggregateTransactionBodyBuilder aggregateTransactionBody;

    protected AggregateCompleteTransactionBuilder(DataInputStream stream) {
        super(stream);
        this.aggregateTransactionBody = AggregateTransactionBodyBuilder.loadFromBinary(stream);
    }

    protected AggregateCompleteTransactionBuilder(SignatureDto signature, KeyDto signerPublicKey, byte version, NetworkTypeDto network, EntityTypeDto type, AmountDto fee, TimestampDto deadline, Hash256Dto transactionsHash, List<EmbeddedTransactionBuilder> transactions, List<CosignatureBuilder> cosignatures) {
        super(signature, signerPublicKey, version, network, type, fee, deadline);
        this.aggregateTransactionBody = AggregateTransactionBodyBuilder.create(transactionsHash, transactions, cosignatures);
    }

    public static AggregateCompleteTransactionBuilder create(SignatureDto signature, KeyDto signerPublicKey, byte version, NetworkTypeDto network, EntityTypeDto type, AmountDto fee, TimestampDto deadline, Hash256Dto transactionsHash, List<EmbeddedTransactionBuilder> transactions, List<CosignatureBuilder> cosignatures) {
        return new AggregateCompleteTransactionBuilder(signature, signerPublicKey, version, network, type, fee, deadline, transactionsHash, transactions, cosignatures);
    }

    public Hash256Dto getTransactionsHash() {
        return this.aggregateTransactionBody.getTransactionsHash();
    }

    public List<EmbeddedTransactionBuilder> getTransactions() {
        return this.aggregateTransactionBody.getTransactions();
    }

    public List<CosignatureBuilder> getCosignatures() {
        return this.aggregateTransactionBody.getCosignatures();
    }

    @Override
    public int getSize() {
        int size = super.getSize();
        return size += this.aggregateTransactionBody.getSize();
    }

    public static AggregateCompleteTransactionBuilder loadFromBinary(DataInputStream stream) {
        return new AggregateCompleteTransactionBuilder(stream);
    }

    @Override
    public byte[] serialize() {
        return GeneratorUtils.serialize(dataOutputStream -> {
            byte[] superBytes = super.serialize();
            dataOutputStream.write(superBytes, 0, superBytes.length);
            byte[] aggregateTransactionBodyBytes = this.aggregateTransactionBody.serialize();
            dataOutputStream.write(aggregateTransactionBodyBytes, 0, aggregateTransactionBodyBytes.length);
        });
    }
}

