/*
 * Decompiled with CFR 0.152.
 */
package io.nem.catapult.builders;

import io.nem.catapult.builders.GeneratorUtils;
import io.nem.catapult.builders.Serializer;
import java.io.DataInputStream;
import java.nio.ByteBuffer;

public final class AddressDto
implements Serializer {
    private final ByteBuffer address;

    public AddressDto(ByteBuffer address) {
        GeneratorUtils.notNull(address, "address is null", new Object[0]);
        GeneratorUtils.isTrue(address.array().length == 25, "address should be 25 bytes", new Object[0]);
        this.address = address;
    }

    public AddressDto(DataInputStream stream) {
        try {
            this.address = ByteBuffer.allocate(25);
            stream.readFully(this.address.array());
        }
        catch (Exception e) {
            throw GeneratorUtils.getExceptionToPropagate(e);
        }
    }

    public ByteBuffer getAddress() {
        return this.address;
    }

    @Override
    public int getSize() {
        return 25;
    }

    public static AddressDto loadFromBinary(DataInputStream stream) {
        return new AddressDto(stream);
    }

    @Override
    public byte[] serialize() {
        return GeneratorUtils.serialize(dataOutputStream -> dataOutputStream.write(this.address.array(), 0, this.address.array().length));
    }
}

