/*
 * Decompiled with CFR 0.152.
 */
package io.nem.catapult.builders;

import io.nem.catapult.builders.AddressDto;
import io.nem.catapult.builders.AliasActionDto;
import io.nem.catapult.builders.GeneratorUtils;
import io.nem.catapult.builders.NamespaceIdDto;
import io.nem.catapult.builders.Serializer;
import java.io.DataInputStream;

public final class AddressAliasTransactionBodyBuilder
implements Serializer {
    private final NamespaceIdDto namespaceId;
    private final AddressDto address;
    private final AliasActionDto aliasAction;

    protected AddressAliasTransactionBodyBuilder(DataInputStream stream) {
        this.namespaceId = NamespaceIdDto.loadFromBinary(stream);
        this.address = AddressDto.loadFromBinary(stream);
        this.aliasAction = AliasActionDto.loadFromBinary(stream);
    }

    protected AddressAliasTransactionBodyBuilder(NamespaceIdDto namespaceId, AddressDto address, AliasActionDto aliasAction) {
        GeneratorUtils.notNull(namespaceId, "namespaceId is null", new Object[0]);
        GeneratorUtils.notNull(address, "address is null", new Object[0]);
        GeneratorUtils.notNull(aliasAction, "aliasAction is null", new Object[0]);
        this.namespaceId = namespaceId;
        this.address = address;
        this.aliasAction = aliasAction;
    }

    public static AddressAliasTransactionBodyBuilder create(NamespaceIdDto namespaceId, AddressDto address, AliasActionDto aliasAction) {
        return new AddressAliasTransactionBodyBuilder(namespaceId, address, aliasAction);
    }

    public NamespaceIdDto getNamespaceId() {
        return this.namespaceId;
    }

    public AddressDto getAddress() {
        return this.address;
    }

    public AliasActionDto getAliasAction() {
        return this.aliasAction;
    }

    @Override
    public int getSize() {
        int size = 0;
        size += this.namespaceId.getSize();
        size += this.address.getSize();
        return size += this.aliasAction.getSize();
    }

    public static AddressAliasTransactionBodyBuilder loadFromBinary(DataInputStream stream) {
        return new AddressAliasTransactionBodyBuilder(stream);
    }

    @Override
    public byte[] serialize() {
        return GeneratorUtils.serialize(dataOutputStream -> {
            byte[] namespaceIdBytes = this.namespaceId.serialize();
            dataOutputStream.write(namespaceIdBytes, 0, namespaceIdBytes.length);
            byte[] addressBytes = this.address.serialize();
            dataOutputStream.write(addressBytes, 0, addressBytes.length);
            byte[] aliasActionBytes = this.aliasAction.serialize();
            dataOutputStream.write(aliasActionBytes, 0, aliasActionBytes.length);
        });
    }
}

