/*
 * Decompiled with CFR 0.152.
 */
package io.nem.catapult.builders;

import io.nem.catapult.builders.AccountMetadataTransactionBodyBuilder;
import io.nem.catapult.builders.AmountDto;
import io.nem.catapult.builders.EntityTypeDto;
import io.nem.catapult.builders.GeneratorUtils;
import io.nem.catapult.builders.KeyDto;
import io.nem.catapult.builders.NetworkTypeDto;
import io.nem.catapult.builders.Serializer;
import io.nem.catapult.builders.SignatureDto;
import io.nem.catapult.builders.TimestampDto;
import io.nem.catapult.builders.TransactionBuilder;
import java.io.DataInputStream;
import java.nio.ByteBuffer;

public final class AccountMetadataTransactionBuilder
extends TransactionBuilder
implements Serializer {
    private final AccountMetadataTransactionBodyBuilder accountMetadataTransactionBody;

    protected AccountMetadataTransactionBuilder(DataInputStream stream) {
        super(stream);
        this.accountMetadataTransactionBody = AccountMetadataTransactionBodyBuilder.loadFromBinary(stream);
    }

    protected AccountMetadataTransactionBuilder(SignatureDto signature, KeyDto signerPublicKey, byte version, NetworkTypeDto network, EntityTypeDto type, AmountDto fee, TimestampDto deadline, KeyDto targetPublicKey, long scopedMetadataKey, short valueSizeDelta, ByteBuffer value) {
        super(signature, signerPublicKey, version, network, type, fee, deadline);
        this.accountMetadataTransactionBody = AccountMetadataTransactionBodyBuilder.create(targetPublicKey, scopedMetadataKey, valueSizeDelta, value);
    }

    public static AccountMetadataTransactionBuilder create(SignatureDto signature, KeyDto signerPublicKey, byte version, NetworkTypeDto network, EntityTypeDto type, AmountDto fee, TimestampDto deadline, KeyDto targetPublicKey, long scopedMetadataKey, short valueSizeDelta, ByteBuffer value) {
        return new AccountMetadataTransactionBuilder(signature, signerPublicKey, version, network, type, fee, deadline, targetPublicKey, scopedMetadataKey, valueSizeDelta, value);
    }

    public KeyDto getTargetPublicKey() {
        return this.accountMetadataTransactionBody.getTargetPublicKey();
    }

    public long getScopedMetadataKey() {
        return this.accountMetadataTransactionBody.getScopedMetadataKey();
    }

    public short getValueSizeDelta() {
        return this.accountMetadataTransactionBody.getValueSizeDelta();
    }

    public ByteBuffer getValue() {
        return this.accountMetadataTransactionBody.getValue();
    }

    @Override
    public int getSize() {
        int size = super.getSize();
        return size += this.accountMetadataTransactionBody.getSize();
    }

    public static AccountMetadataTransactionBuilder loadFromBinary(DataInputStream stream) {
        return new AccountMetadataTransactionBuilder(stream);
    }

    @Override
    public byte[] serialize() {
        return GeneratorUtils.serialize(dataOutputStream -> {
            byte[] superBytes = super.serialize();
            dataOutputStream.write(superBytes, 0, superBytes.length);
            byte[] accountMetadataTransactionBodyBytes = this.accountMetadataTransactionBody.serialize();
            dataOutputStream.write(accountMetadataTransactionBodyBytes, 0, accountMetadataTransactionBodyBytes.length);
        });
    }
}

